/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.tools.devsvr.api;

import java.util.Date;
import java.util.HashSet;
import org.overlord.apiman.dt.api.beans.apps.ApplicationBean;
import org.overlord.apiman.dt.api.beans.apps.ApplicationStatus;
import org.overlord.apiman.dt.api.beans.apps.ApplicationVersionBean;
import org.overlord.apiman.dt.api.beans.idm.PermissionType;
import org.overlord.apiman.dt.api.beans.idm.RoleBean;
import org.overlord.apiman.dt.api.beans.idm.RoleMembershipBean;
import org.overlord.apiman.dt.api.beans.orgs.OrganizationBean;
import org.overlord.apiman.dt.api.beans.plans.PlanBean;
import org.overlord.apiman.dt.api.beans.plans.PlanStatus;
import org.overlord.apiman.dt.api.beans.plans.PlanVersionBean;
import org.overlord.apiman.dt.api.beans.policies.PolicyDefinitionBean;
import org.overlord.apiman.dt.api.beans.policies.PolicyDefinitionTemplateBean;
import org.overlord.apiman.dt.api.beans.services.EndpointType;
import org.overlord.apiman.dt.api.beans.services.ServiceBean;
import org.overlord.apiman.dt.api.beans.services.ServicePlanBean;
import org.overlord.apiman.dt.api.beans.services.ServiceStatus;
import org.overlord.apiman.dt.api.beans.services.ServiceVersionBean;
import org.overlord.apiman.dt.api.core.IIdmStorage;
import org.overlord.apiman.dt.api.core.IStorage;
import org.overlord.apiman.dt.api.core.exceptions.StorageException;
import org.overlord.apiman.dt.test.server.DefaultTestDataSeeder;

public class DtApiDataSeeder
extends DefaultTestDataSeeder {
    public void seed(IIdmStorage idmStorage, IStorage storage) throws StorageException {
        super.seed(idmStorage, storage);
        RoleBean role = new RoleBean();
        role.setId("OrganizationOwner");
        role.setName("Organization Owner");
        role.setAutoGrant(Boolean.valueOf(true));
        role.setDescription("This role is automatically given to users when they create an organization.  It grants all permissions.");
        role.setCreatedBy("admin");
        role.setCreatedOn(new Date());
        role.setPermissions(new HashSet());
        role.getPermissions().add(PermissionType.orgView);
        role.getPermissions().add(PermissionType.orgEdit);
        role.getPermissions().add(PermissionType.orgAdmin);
        role.getPermissions().add(PermissionType.appView);
        role.getPermissions().add(PermissionType.appEdit);
        role.getPermissions().add(PermissionType.appAdmin);
        role.getPermissions().add(PermissionType.planView);
        role.getPermissions().add(PermissionType.planEdit);
        role.getPermissions().add(PermissionType.planAdmin);
        role.getPermissions().add(PermissionType.svcView);
        role.getPermissions().add(PermissionType.svcEdit);
        role.getPermissions().add(PermissionType.svcAdmin);
        idmStorage.createRole(role);
        role = new RoleBean();
        role.setId("ApplicationDeveloper");
        role.setName("Application Developer");
        role.setDescription("This role allows users to perform standard application development tasks (manage applications but not services or plans).");
        role.setCreatedBy("admin");
        role.setCreatedOn(new Date());
        role.setPermissions(new HashSet());
        role.getPermissions().add(PermissionType.orgView);
        role.getPermissions().add(PermissionType.appView);
        role.getPermissions().add(PermissionType.appEdit);
        role.getPermissions().add(PermissionType.appAdmin);
        idmStorage.createRole(role);
        role = new RoleBean();
        role.setId("ServiceDeveloper");
        role.setName("Service Developer");
        role.setDescription("This role allows users to perform standard service development tasks such as managing services and plans.");
        role.setCreatedBy("admin");
        role.setCreatedOn(new Date());
        role.setPermissions(new HashSet());
        role.getPermissions().add(PermissionType.orgView);
        role.getPermissions().add(PermissionType.svcView);
        role.getPermissions().add(PermissionType.svcEdit);
        role.getPermissions().add(PermissionType.svcAdmin);
        role.getPermissions().add(PermissionType.planView);
        role.getPermissions().add(PermissionType.planEdit);
        role.getPermissions().add(PermissionType.planAdmin);
        idmStorage.createRole(role);
        OrganizationBean org = new OrganizationBean();
        org.setId("JBossOverlord");
        org.setName("JBoss Overlord");
        org.setDescription("Overlord is the umbrella project that will bring governance to the JBoss SOA Platform and eventually beyond.");
        org.setCreatedOn(new Date());
        org.setCreatedBy("admin");
        storage.create((Object)org);
        org = new OrganizationBean();
        org.setId("ApereoBedework");
        org.setName("Apereo Bedework");
        org.setDescription("Bedework is an open-source enterprise calendar system that supports public, personal, and group calendaring.");
        org.setCreatedOn(new Date());
        org.setCreatedBy("admin");
        storage.create((Object)org);
        RoleMembershipBean membership = RoleMembershipBean.create((String)"admin", (String)"OrganizationOwner", (String)"JBossOverlord");
        membership.setCreatedOn(new Date());
        idmStorage.createMembership(membership);
        membership = RoleMembershipBean.create((String)"admin", (String)"OrganizationOwner", (String)"ApereoBedework");
        membership.setCreatedOn(new Date());
        idmStorage.createMembership(membership);
        PlanBean plan = new PlanBean();
        plan.setId("Platinum");
        plan.setName("Platinum");
        plan.setDescription("Provides subscribing applications with full access to the Services in this Organization.");
        plan.setOrganizationId("JBossOverlord");
        plan.setCreatedBy("admin");
        plan.setCreatedOn(new Date());
        storage.create((Object)plan);
        PlanVersionBean pvb = new PlanVersionBean();
        pvb.setVersion("1.0");
        pvb.setStatus(PlanStatus.Created);
        pvb.setPlan(plan);
        pvb.setCreatedBy("admin");
        pvb.setCreatedOn(new Date());
        pvb.setModifiedBy("admin");
        pvb.setModifiedOn(new Date());
        storage.create((Object)pvb);
        plan = new PlanBean();
        plan.setId("Gold");
        plan.setName("Gold");
        plan.setDescription("Provides subscribing applications with full access to a subset of Services. Also allows partial (rate limited) access to the rest.");
        plan.setOrganizationId("JBossOverlord");
        plan.setCreatedBy("admin");
        plan.setCreatedOn(new Date());
        storage.create((Object)plan);
        pvb = new PlanVersionBean();
        pvb.setVersion("1.0");
        pvb.setStatus(PlanStatus.Created);
        pvb.setPlan(plan);
        pvb.setCreatedBy("admin");
        pvb.setCreatedOn(new Date());
        pvb.setModifiedBy("admin");
        pvb.setModifiedOn(new Date());
        storage.create((Object)pvb);
        pvb = new PlanVersionBean();
        pvb.setVersion("1.2");
        pvb.setStatus(PlanStatus.Created);
        pvb.setPlan(plan);
        pvb.setCreatedBy("bwayne");
        pvb.setCreatedOn(new Date());
        pvb.setModifiedBy("bwayne");
        pvb.setModifiedOn(new Date());
        storage.create((Object)pvb);
        ApplicationBean app = new ApplicationBean();
        app.setId("dtgov");
        app.setName("dtgov");
        app.setDescription("This is the official Git repository for the Governance DTGov project, which is intended to be a part of the JBoss Overlord.");
        app.setOrganizationId("JBossOverlord");
        app.setCreatedBy("admin");
        app.setCreatedOn(new Date());
        storage.create((Object)app);
        ApplicationVersionBean avb = new ApplicationVersionBean();
        avb.setVersion("1.0");
        avb.setStatus(ApplicationStatus.Created);
        avb.setApplication(app);
        avb.setCreatedBy("admin");
        avb.setCreatedOn(new Date());
        avb.setModifiedBy("admin");
        avb.setModifiedOn(new Date());
        storage.create((Object)avb);
        app = new ApplicationBean();
        app.setId("rtgov");
        app.setName("rtgov");
        app.setDescription("This component provides the infrastructure to capture service activity information and then correlate...");
        app.setOrganizationId("JBossOverlord");
        app.setCreatedBy("admin");
        app.setCreatedOn(new Date());
        storage.create((Object)app);
        avb = new ApplicationVersionBean();
        avb.setVersion("1.0");
        avb.setStatus(ApplicationStatus.Created);
        avb.setApplication(app);
        avb.setCreatedBy("admin");
        avb.setCreatedOn(new Date());
        avb.setModifiedBy("admin");
        avb.setModifiedOn(new Date());
        storage.create((Object)avb);
        app = new ApplicationBean();
        app.setId("gadget-server");
        app.setName("gadget-server");
        app.setDescription("This is a project that builds on the Apache Shindig as the open social gadget containers.");
        app.setOrganizationId("JBossOverlord");
        app.setCreatedBy("admin");
        app.setCreatedOn(new Date());
        storage.create((Object)app);
        avb = new ApplicationVersionBean();
        avb.setVersion("1.0");
        avb.setStatus(ApplicationStatus.Created);
        avb.setApplication(app);
        avb.setCreatedBy("admin");
        avb.setCreatedOn(new Date());
        avb.setModifiedBy("admin");
        avb.setModifiedOn(new Date());
        storage.create((Object)avb);
        ServiceBean service = new ServiceBean();
        service.setId("s-ramp-api");
        service.setName("s-ramp-api");
        service.setDescription("Allows S-RAMP repository users to communicate with the repository via an Atom based API.");
        service.setOrganizationId("JBossOverlord");
        service.setCreatedOn(new Date());
        service.setCreatedBy("admin");
        storage.create((Object)service);
        ServiceVersionBean svb = new ServiceVersionBean();
        svb.setVersion("1.0");
        svb.setStatus(ServiceStatus.Ready);
        svb.setService(service);
        svb.setCreatedBy("admin");
        svb.setCreatedOn(new Date());
        svb.setModifiedBy("admin");
        svb.setModifiedOn(new Date());
        svb.setEndpoint("http://localhost:9001/echo/s-ramp-server/");
        svb.setEndpointType(EndpointType.rest);
        ServicePlanBean spb = new ServicePlanBean();
        spb.setPlanId("Gold");
        spb.setVersion("1.0");
        svb.addPlan(spb);
        storage.create((Object)svb);
        PolicyDefinitionBean whitelistPolicyDef = new PolicyDefinitionBean();
        whitelistPolicyDef.setId("IPWhitelistPolicy");
        whitelistPolicyDef.setName("IP Whitelist Policy");
        whitelistPolicyDef.setDescription("Only requests that originate from a specified set of valid IP addresses will be allowed through.");
        whitelistPolicyDef.setIcon("filter");
        whitelistPolicyDef.setPolicyImpl("class:org.overlord.apiman.engine.policies.IPWhitelistPolicy");
        PolicyDefinitionTemplateBean templateBean = new PolicyDefinitionTemplateBean();
        templateBean.setLanguage(null);
        templateBean.setTemplate("Only requests that originate from the set of @{ipList.size()} configured IP address(es) will be allowed to invoke the managed service.");
        whitelistPolicyDef.getTemplates().add(templateBean);
        storage.create((Object)whitelistPolicyDef);
        PolicyDefinitionBean blacklistPolicyDef = new PolicyDefinitionBean();
        blacklistPolicyDef.setId("IPBlacklistPolicy");
        blacklistPolicyDef.setName("IP Blacklist Policy");
        blacklistPolicyDef.setDescription("Only requests that originate from a specified set of valid IP addresses will be allowed through.");
        blacklistPolicyDef.setIcon("thumbs-down");
        blacklistPolicyDef.setPolicyImpl("class:org.overlord.apiman.engine.policies.IPBlacklistPolicy");
        templateBean = new PolicyDefinitionTemplateBean();
        templateBean.setLanguage(null);
        templateBean.setTemplate("Requests that originate from the set of @{ipList.size()} configured IP address(es) will be denied access to the managed service.");
        blacklistPolicyDef.getTemplates().add(templateBean);
        storage.create((Object)blacklistPolicyDef);
        PolicyDefinitionBean basicAuthPolicyDef = new PolicyDefinitionBean();
        basicAuthPolicyDef.setId("BASICAuthenticationPolicy");
        basicAuthPolicyDef.setName("BASIC Authentication Policy");
        basicAuthPolicyDef.setDescription("Enables HTTP BASIC Authentication on a service.  Some configuration required.");
        basicAuthPolicyDef.setIcon("lock");
        basicAuthPolicyDef.setPolicyImpl("class:org.overlord.apiman.engine.policies.BasicAuthenticationPolicy");
        templateBean = new PolicyDefinitionTemplateBean();
        templateBean.setLanguage(null);
        templateBean.setTemplate("Access to the service is protected by BASIC Authentication through the '@{realm}' authentication realm.  @if{forwardIdentityHttpHeader != null}Successfully authenticated requests will forward the authenticated identity to the back end service via the '@{forwardIdentityHttpHeader}' custom HTTP header.@end{}");
        basicAuthPolicyDef.getTemplates().add(templateBean);
        storage.create((Object)basicAuthPolicyDef);
    }
}

