/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.tools.devsvr.ui;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.overlord.apiman.dt.ui.client.shared.beans.ApiAuthType;
import org.overlord.apiman.dt.ui.server.UIConfig;
import org.overlord.apiman.dt.ui.server.servlets.ConfigurationServlet;
import org.overlord.apiman.dt.ui.server.servlets.TokenRefreshServlet;
import org.overlord.apiman.tools.devsvr.ui.ApiManDtUiDevServerEnvironment;
import org.overlord.apiman.tools.devsvr.ui.ApiManDtUiTokenGenerator;
import org.overlord.commons.auth.filters.HttpRequestThreadLocalFilter;
import org.overlord.commons.dev.server.DevServerEnvironment;
import org.overlord.commons.dev.server.ErraiDevServer;
import org.overlord.commons.dev.server.MultiDefaultServlet;
import org.overlord.commons.dev.server.discovery.ErraiWebAppModuleFromMavenDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.IModuleDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.JarModuleFromIDEDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.JarModuleFromMavenDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.WebAppModuleFromIDEDiscoveryStrategy;
import org.overlord.commons.gwt.server.filters.GWTCacheControlFilter;
import org.overlord.commons.gwt.server.filters.ResourceCacheControlFilter;
import org.overlord.commons.i18n.server.filters.LocaleFilter;
import org.overlord.commons.ui.header.OverlordHeaderDataJS;

public class ApiManDtUiDevServer
extends ErraiDevServer {
    private static final int API_PORT = 7070;
    private static final int GATEWAY_PORT = 6666;
    private static final String APIMAN_RT_API_SERVER_PORT = "apiman.api.server.port";
    private static final String APIMAN_RT_GATEWAY_SERVER_PORT = "apiman.gateway.server.port";
    private static final String[] USERS = new String[]{"admin", "eric", "gary", "kevin", "admin2", "bwayne", "ckent", "dprince"};

    public static void main(String[] args) throws Exception {
        ApiManDtUiDevServer devServer = new ApiManDtUiDevServer(args);
        devServer.enableDebug();
        devServer.go();
    }

    public ApiManDtUiDevServer(String[] args) {
        super(args);
    }

    protected String getErraiModuleId() {
        return "apiman-dt-ui";
    }

    protected void preConfig() {
        int apiPort = ApiManDtUiDevServer.getApiPort();
        int gatewayPort = ApiManDtUiDevServer.getGatewayPort();
        System.setProperty("apiman-dt-ui.dt-api.endpoint", "http://localhost:" + apiPort + "/apiman-dt-api");
        System.setProperty("apiman-dt-ui.dt-api.authentication.type", ApiAuthType.samlBearerToken.toString());
        System.setProperty("apiman-dt-ui.dt-api.authentication.token.generator", ApiManDtUiTokenGenerator.class.getName());
        System.setProperty("apiman-dt-ui.gateway.base-url", "http://localhost:" + gatewayPort + "/gateway");
    }

    private static int getGatewayPort() {
        int port = 6666;
        if (System.getProperty(APIMAN_RT_GATEWAY_SERVER_PORT) != null) {
            port = new Integer(System.getProperty(APIMAN_RT_GATEWAY_SERVER_PORT));
        }
        return port;
    }

    private static int getApiPort() {
        int port = 7070;
        if (System.getProperty(APIMAN_RT_API_SERVER_PORT) != null) {
            port = new Integer(System.getProperty(APIMAN_RT_API_SERVER_PORT));
        }
        return port;
    }

    protected ApiManDtUiDevServerEnvironment createDevEnvironment() {
        return new ApiManDtUiDevServerEnvironment(this.args);
    }

    protected void addModules(DevServerEnvironment environment) {
        environment.addModule("apiman-dt-ui", new IModuleDiscoveryStrategy[]{new WebAppModuleFromIDEDiscoveryStrategy(UIConfig.class), new ErraiWebAppModuleFromMavenDiscoveryStrategy(UIConfig.class)});
        environment.addModule("overlord-commons-uiheader", new IModuleDiscoveryStrategy[]{new JarModuleFromIDEDiscoveryStrategy(OverlordHeaderDataJS.class, "src/main/resources/META-INF/resources"), new JarModuleFromMavenDiscoveryStrategy(OverlordHeaderDataJS.class, "/META-INF/resources")});
    }

    protected void addModulesToJetty(DevServerEnvironment environment, ContextHandlerCollection handlers) throws Exception {
        String[] fileTypes;
        super.addModulesToJetty(environment, handlers);
        ServletContextHandler apiManDtUI = new ServletContextHandler(1);
        apiManDtUI.setWelcomeFiles(new String[]{"index.html"});
        apiManDtUI.setSecurityHandler(this.createSecurityHandler());
        apiManDtUI.setContextPath("/apiman-ui");
        apiManDtUI.setWelcomeFiles(new String[]{"index.html"});
        apiManDtUI.setResourceBase(environment.getModuleDir("apiman-dt-ui").getCanonicalPath());
        apiManDtUI.addFilter(HttpRequestThreadLocalFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        apiManDtUI.addFilter(GWTCacheControlFilter.class, "/app/*", EnumSet.of(DispatcherType.REQUEST));
        apiManDtUI.addFilter(ResourceCacheControlFilter.class, "/css/*", EnumSet.of(DispatcherType.REQUEST));
        apiManDtUI.addFilter(ResourceCacheControlFilter.class, "/images/*", EnumSet.of(DispatcherType.REQUEST));
        apiManDtUI.addFilter(ResourceCacheControlFilter.class, "/js/*", EnumSet.of(DispatcherType.REQUEST));
        apiManDtUI.addFilter(LocaleFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder headerDataServlet = new ServletHolder(OverlordHeaderDataJS.class);
        headerDataServlet.setInitParameter("app-id", "apiman-dt-ui");
        apiManDtUI.addServlet(headerDataServlet, "/js/overlord-header-data.nocache.js");
        apiManDtUI.addServlet(ConfigurationServlet.class, "/js/configuration.nocache.js");
        apiManDtUI.addServlet(TokenRefreshServlet.class, "/rest/tokenRefresh");
        ServletHolder resources = new ServletHolder((Servlet)new MultiDefaultServlet());
        resources.setInitParameter("resourceBase", "/");
        resources.setInitParameter("resourceBases", environment.getModuleDir("apiman-dt-ui").getCanonicalPath() + "|" + environment.getModuleDir("overlord-commons-uiheader").getCanonicalPath());
        resources.setInitParameter("dirAllowed", "true");
        resources.setInitParameter("pathInfoOnly", "false");
        for (String fileType : fileTypes = new String[]{"html", "js", "css", "png", "gif", "woff", "ttf"}) {
            apiManDtUI.addServlet(resources, "*." + fileType);
        }
        handlers.addHandler((Handler)apiManDtUI);
    }

    protected void postStart(DevServerEnvironment environment) throws Exception {
    }

    private SecurityHandler createSecurityHandler() {
        HashLoginService l = new HashLoginService();
        String[] arr$ = USERS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String user;
            String pwd = user = arr$[i$];
            String[] roles = new String[]{"apiuser"};
            if (user.startsWith("admin")) {
                roles = new String[]{"apiuser", "apiadmin"};
            }
            l.putUser(user, Credential.getCredential((String)pwd), roles);
        }
        l.setName("apimanrealm");
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"apiuser", "apiadmin"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("apimanrealm");
        csh.addConstraintMapping(cm);
        csh.setLoginService((LoginService)l);
        csh.setSessionRenewedOnAuthentication(false);
        return csh;
    }
}

