/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.active.collection.rest;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.jackson.map.ObjectMapper;
import org.overlord.bam.active.collection.ActiveCollection;
import org.overlord.bam.active.collection.ActiveCollectionManager;
import org.overlord.bam.active.collection.ActiveList;
import org.overlord.bam.active.collection.QuerySpec;
import org.overlord.bam.active.collection.util.ActiveCollectionUtil;

@Path(value="/acm")
@ApplicationScoped
public class RESTActiveCollectionServer {
    private static final Logger LOG = Logger.getLogger(RESTActiveCollectionServer.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private ActiveCollectionManager _acmManager = null;

    public RESTActiveCollectionServer() {
        try {
            BeanManager bm = (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
            Set beans = bm.getBeans(ActiveCollectionManager.class, new Annotation[0]);
            for (Bean b : beans) {
                CreationalContext<Object> cc = new CreationalContext<Object>(){

                    public void push(Object arg0) {
                    }

                    public void release() {
                    }
                };
                this._acmManager = (ActiveCollectionManager)b.create((CreationalContext)cc);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Active collection manager=" + this._acmManager + " for bean=" + b);
                }
                if (this._acmManager == null) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setActivityCollectionManager(ActiveCollectionManager acm) {
        LOG.info("Set Active Collection Manager=" + acm);
        this._acmManager = acm;
    }

    @POST
    @Path(value="/query")
    @Produces(value={"application/json"})
    public String query(String qspec) throws Exception {
        String ret = "";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Active Collection JSON Query=" + qspec);
        }
        QuerySpec qs = ActiveCollectionUtil.deserializeQuerySpec((byte[])qspec.getBytes());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Active Collection Query=" + qs);
        }
        if (this._acmManager == null) {
            throw new Exception("Active Collection Manager is not available");
        }
        ActiveList alist = (ActiveList)this._acmManager.getActiveCollection(qs.getCollection());
        if (alist == null) {
            if (qs.getParent() == null || qs.getPredicate() == null) {
                throw new Exception("Collection '" + qs.getCollection() + "' does not exist, and either the parent or " + "predicate have not been defined");
            }
            ActiveList parent = (ActiveList)this._acmManager.getActiveCollection(qs.getParent());
            if (parent != null) {
                alist = (ActiveList)this._acmManager.create(qs.getCollection(), (ActiveCollection)parent, qs.getPredicate());
            } else {
                throw new Exception("Unknown parent collection '" + qs.getParent() + "'");
            }
        }
        if (alist != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int count = 0;
            int max = alist.getSize();
            if (max > 0) {
                out.write("[".getBytes());
            }
            for (Object obj : alist) {
                MAPPER.writeValue((OutputStream)out, obj);
                if (++count >= max) continue;
                out.write(",".getBytes());
            }
            if (max > 0) {
                out.write("]".getBytes());
            }
            out.close();
            ret = new String(out.toByteArray());
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Active Collection Result=" + ret);
        }
        return ret;
    }
}

