/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.server.impl;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.overlord.bam.activity.model.ActivityType;
import org.overlord.bam.activity.model.ActivityUnit;
import org.overlord.bam.activity.model.Context;
import org.overlord.bam.activity.model.bpm.BPMActivityType;
import org.overlord.bam.activity.model.soa.RPCActivityType;
import org.overlord.bam.activity.server.ActivityNotifier;
import org.overlord.bam.activity.server.ActivityServer;
import org.overlord.bam.activity.server.ActivityStore;
import org.overlord.bam.activity.server.QuerySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityServerImpl
implements ActivityServer {
    private static final String PROCESS_CONTEXT_NAME = "process";
    @Inject
    private ActivityStore _store = null;
    private List<ActivityNotifier> _notifiers = new Vector<ActivityNotifier>();
    @Inject
    @Any
    private Instance<ActivityNotifier> _injectedNotifiers = null;
    private boolean _handleDuplicateIds = true;

    public void setActivityStore(ActivityStore store) {
        this._store = store;
    }

    public ActivityStore getActivityStore() {
        return this._store;
    }

    public List<ActivityNotifier> getActivityNotifiers() {
        return this._notifiers;
    }

    public void setHandleDuplicateIds(boolean b) {
        this._handleDuplicateIds = b;
    }

    public boolean getHandleDuplicateIds() {
        return this._handleDuplicateIds;
    }

    public void store(List<ActivityUnit> activities) throws Exception {
        for (ActivityUnit au : activities) {
            this.processActivityUnit(au);
        }
        if (this._store == null) {
            throw new Exception("Activity Store is unavailable");
        }
        this._store.store(activities);
        for (ActivityNotifier notifier : this._notifiers) {
            notifier.notify(activities);
        }
        if (this._injectedNotifiers != null) {
            for (ActivityNotifier notifier : this._injectedNotifiers) {
                notifier.notify(activities);
            }
        }
    }

    protected void processActivityUnit(ActivityUnit au) {
        if (au.getId() == null) {
            au.setId(this.createUniqueId());
        }
        int index = 0;
        HashSet<String> ids = this._handleDuplicateIds ? new HashSet<String>() : null;
        for (ActivityType at : au.getActivityTypes()) {
            at.setActivityUnitId(au.getId());
            at.setActivityUnitIndex(index++);
            if (at instanceof RPCActivityType) {
                if (this._handleDuplicateIds && ids.contains(((RPCActivityType)at).getMessageId())) continue;
                if (this._handleDuplicateIds) {
                    ids.add(((RPCActivityType)at).getMessageId());
                }
                au.getContext().add(new Context(2, null, ((RPCActivityType)at).getMessageId()));
                continue;
            }
            if (!(at instanceof BPMActivityType) || this._handleDuplicateIds && ids.contains(((BPMActivityType)at).getInstanceId())) continue;
            if (this._handleDuplicateIds) {
                ids.add(((BPMActivityType)at).getInstanceId());
            }
            au.getContext().add(new Context(1, PROCESS_CONTEXT_NAME, ((BPMActivityType)at).getInstanceId()));
        }
    }

    protected String createUniqueId() {
        return UUID.randomUUID().toString();
    }

    public List<ActivityUnit> query(QuerySpec query) throws Exception {
        if (this._store == null) {
            throw new Exception("Activity Store is unavailable");
        }
        return this._store.query(query);
    }
}

