/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.server.impl;

import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.overlord.bam.activity.model.ActivityType;
import org.overlord.bam.activity.model.ActivityUnit;
import org.overlord.bam.activity.server.ActivityNotifier;
import org.overlord.bam.activity.server.ActivityServer;
import org.overlord.bam.activity.server.ActivityStore;
import org.overlord.bam.activity.server.QuerySpec;

public class ActivityServerImpl
implements ActivityServer {
    @Inject
    private ActivityStore _store = null;
    private List<ActivityNotifier> _notifiers = new Vector<ActivityNotifier>();
    @Inject
    @Any
    private Instance<ActivityNotifier> _injectedNotifiers = null;

    public void setActivityStore(ActivityStore store) {
        this._store = store;
    }

    public ActivityStore getActivityStore() {
        return this._store;
    }

    public List<ActivityNotifier> getActivityNotifiers() {
        return this._notifiers;
    }

    public void store(List<ActivityUnit> activities) throws Exception {
        for (ActivityUnit au : activities) {
            this.processActivityUnit(au);
        }
        if (this._store == null) {
            throw new Exception("Activity Store is unavailable");
        }
        this._store.store(activities);
        for (ActivityNotifier notifier : this._notifiers) {
            notifier.notify(activities);
        }
        if (this._injectedNotifiers != null) {
            for (ActivityNotifier notifier : this._injectedNotifiers) {
                notifier.notify(activities);
            }
        }
    }

    protected void processActivityUnit(ActivityUnit au) {
        if (au.getId() == null) {
            au.setId(this.createUniqueId());
        }
        int index = 0;
        for (ActivityType at : au.getActivityTypes()) {
            at.setUnitId(au.getId());
            at.setUnitIndex(index++);
        }
    }

    protected String createUniqueId() {
        return UUID.randomUUID().toString();
    }

    public ActivityUnit getActivityUnit(String id) throws Exception {
        if (this._store == null) {
            throw new Exception("Activity Store is unavailable");
        }
        return this._store.getActivityUnit(id);
    }

    public List<ActivityType> query(QuerySpec query) throws Exception {
        if (this._store == null) {
            throw new Exception("Activity Store is unavailable");
        }
        return this._store.query(query);
    }
}

