/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.server.jms.client;

import java.io.Serializable;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.overlord.bam.activity.model.ActivityType;
import org.overlord.bam.activity.model.ActivityUnit;
import org.overlord.bam.activity.server.ActivityServer;
import org.overlord.bam.activity.server.QuerySpec;

public class JMSActivityServer
implements ActivityServer {
    private static final String ACTIVITY_MONITOR_SERVER = "ActivityMonitorServer";
    private static final Logger LOG = Logger.getLogger(JMSActivityServer.class.getName());
    private Connection _connection;
    private Session _session;
    private MessageProducer _producer;

    @PostConstruct
    public void init() {
        try {
            Queue queue = HornetQJMSClient.createQueue((String)ACTIVITY_MONITOR_SERVER);
            TransportConfiguration transportConfiguration = new TransportConfiguration(NettyConnectorFactory.class.getName());
            ConnectionFactory cf = (ConnectionFactory)HornetQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{transportConfiguration});
            this._connection = cf.createConnection();
            this._session = this._connection.createSession(false, 1);
            this._producer = this._session.createProducer((Destination)queue);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity-server-jmsc.Messages").getString("ACTIVITY-SERVER-JMSC-1"));
        }
    }

    public void store(List<ActivityUnit> activities) throws Exception {
        ObjectMessage mesg = this._session.createObjectMessage();
        mesg.setObject((Serializable)((Object)activities));
        this._producer.send((Message)mesg);
    }

    public ActivityUnit getActivityUnit(String id) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<ActivityType> getActivityTypes(String context) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<ActivityType> query(QuerySpec query) throws Exception {
        throw new UnsupportedOperationException();
    }

    @PreDestroy
    public void close() {
        try {
            this._session.close();
            this._connection.close();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity-server-jmsc.Messages").getString("ACTIVITY-SERVER-JMSC-2"));
        }
    }
}

