/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.server.rest;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.overlord.bam.activity.model.ActivityUnit;
import org.overlord.bam.activity.server.ActivityServer;
import org.overlord.bam.activity.server.QuerySpec;
import org.overlord.bam.activity.util.ActivityUtil;

@Path(value="/activity")
@ApplicationScoped
public class RESTActivityServer {
    private static final Logger LOG = Logger.getLogger(RESTActivityServer.class.getName());
    private ActivityServer _activityServer = null;

    public RESTActivityServer() {
        try {
            BeanManager bm = (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
            Set beans = bm.getBeans(ActivityServer.class, new Annotation[0]);
            for (Bean b : beans) {
                CreationalContext<Object> cc = new CreationalContext<Object>(){

                    public void push(Object arg0) {
                    }

                    public void release() {
                    }
                };
                this._activityServer = (ActivityServer)b.create((CreationalContext)cc);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Activity server=" + this._activityServer + " for bean=" + b);
                }
                if (this._activityServer == null) continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity-server-rests.Messages").getString("CALL-TRACE-RESTS-1"), e);
        }
    }

    public void setActivityServer(ActivityServer as) {
        LOG.info("Set Activity Server=" + as);
        this._activityServer = as;
    }

    @GET
    @Path(value="/unit")
    @Produces(value={"application/json"})
    public String getActivityUnit(@QueryParam(value="id") String id) throws Exception {
        String ret = "";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Activity Server Get Activity Unit=" + id);
        }
        if (this._activityServer == null) {
            throw new Exception("Activity Server is not available");
        }
        ActivityUnit au = this._activityServer.getActivityUnit(id);
        if (au != null) {
            byte[] b = ActivityUtil.serializeActivityUnit((ActivityUnit)au);
            ret = new String(b);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Activity Server Query Result=" + ret);
        }
        return ret;
    }

    @GET
    @Path(value="/events")
    @Produces(value={"application/json"})
    public String getActivityTypes(@QueryParam(value="context") String context) throws Exception {
        String ret = "";
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Activity Server: Get Activity Types for Context=" + context);
        }
        if (this._activityServer == null) {
            throw new Exception("Activity Server is not available");
        }
        List list = this._activityServer.getActivityTypes(context);
        if (list != null) {
            byte[] b = ActivityUtil.serializeActivityTypeList((List)list);
            ret = new String(b);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Activity Server: Get Activity Types Result=" + ret);
        }
        return ret;
    }

    @POST
    @Path(value="/query")
    @Produces(value={"application/json"})
    public String query(String qspec) throws Exception {
        String ret = "";
        QuerySpec qs = ActivityUtil.deserializeQuerySpec((byte[])qspec.getBytes());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Activity Server Query Spec=" + qs);
        }
        if (this._activityServer == null) {
            throw new Exception("Activity Server is not available");
        }
        List list = this._activityServer.query(qs);
        if (list != null) {
            byte[] b = ActivityUtil.serializeActivityTypeList((List)list);
            ret = new String(b);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Activity Server Query Result=" + ret);
        }
        return ret;
    }

    @POST
    @Path(value="/store")
    public Response store(String acts) throws Exception {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Store activities=" + acts);
        }
        List activities = ActivityUtil.deserializeActivityUnitList((byte[])acts.getBytes());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Store " + activities.size() + " activities");
        }
        if (this._activityServer == null) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Activity Server is not available").build();
        }
        try {
            this._activityServer.store(activities);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Activities stored").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Failed to store activities: " + e)).build();
        }
    }
}

