/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.bam.activity.model.ActivityType;
import org.overlord.bam.activity.model.Context;
import org.overlord.bam.activity.model.Origin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityUnit
implements Externalizable {
    private static final int VERSION = 1;
    private static final Logger LOG = Logger.getLogger(ActivityUnit.class.getName());
    private String _id = null;
    private Origin _origin = null;
    private List<Context> _contexts = new Vector<Context>();
    private List<ActivityType> _activityTypes = new Vector<ActivityType>();

    public ActivityUnit() {
    }

    public ActivityUnit(ActivityUnit act) {
        this._id = act._id;
        if (act._origin != null) {
            this._origin = new Origin(act._origin);
        }
        for (Context context : act._contexts) {
            this._contexts.add(new Context(context));
        }
        for (ActivityType actType : this._activityTypes) {
            try {
                Constructor<?> con = actType.getClass().getConstructor(actType.getClass());
                if (con != null) {
                    this._activityTypes.add((ActivityType)con.newInstance(actType));
                    continue;
                }
                LOG.severe("Failed to create copy - can't find copy constructor for '" + actType.getClass().getName() + "'");
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to create copy", e);
            }
        }
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setOrigin(Origin origin) {
        this._origin = origin;
    }

    public Origin getOrigin() {
        return this._origin;
    }

    public void setContext(List<Context> context) {
        this._contexts = context;
    }

    public List<Context> getContext() {
        return this._contexts;
    }

    public void setActivityTypes(List<ActivityType> activityTypes) {
        this._activityTypes = activityTypes;
    }

    public List<ActivityType> getActivityTypes() {
        return this._activityTypes;
    }

    public String toString() {
        return "ActivityUnit[" + this._id + "] origin=" + this._origin + " contexts=" + this._contexts + " activityTypes=" + this._activityTypes;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeInt(1);
        out.writeObject(this._id);
        out.writeObject(this._origin);
        int len = this._contexts.size();
        out.writeInt(len);
        for (i = 0; i < len; ++i) {
            out.writeObject(this._contexts.get(i));
        }
        len = this._activityTypes.size();
        out.writeInt(len);
        for (i = 0; i < len; ++i) {
            out.writeObject(this._activityTypes.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        in.readInt();
        this._id = (String)in.readObject();
        this._origin = (Origin)in.readObject();
        int len = in.readInt();
        for (i = 0; i < len; ++i) {
            this._contexts.add((Context)in.readObject());
        }
        len = in.readInt();
        for (i = 0; i < len; ++i) {
            this._activityTypes.add((ActivityType)in.readObject());
        }
    }
}

