/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.overlord.bam.activity.model.ActivityUnit;
import org.overlord.bam.activity.model.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySpec
implements Externalizable {
    private static final int VERSION = 1;
    private String _id = null;
    private long _fromTimestamp = 0L;
    private long _toTimestamp = 0L;
    private List<Context> _contexts = new ArrayList<Context>();
    private boolean _contextAND = true;

    public QuerySpec setId(String id) {
        this._id = id;
        return this;
    }

    public String getId() {
        return this._id;
    }

    public QuerySpec setFromTimestamp(long from) {
        this._fromTimestamp = from;
        return this;
    }

    public long getFromTimestamp() {
        return this._fromTimestamp;
    }

    public QuerySpec setToTimestamp(long to) {
        this._toTimestamp = to;
        return this;
    }

    public long getToTimestamp() {
        return this._toTimestamp;
    }

    public QuerySpec addContext(Context context) {
        this._contexts.add(context);
        return this;
    }

    public QuerySpec removeContext(Context context) {
        this._contexts.remove(context);
        return this;
    }

    public List<Context> getContexts() {
        return this._contexts;
    }

    public QuerySpec setContextAND(boolean b) {
        this._contextAND = b;
        return this;
    }

    public boolean isContextAND() {
        return this._contextAND;
    }

    public List<ActivityUnit> evaluate(List<ActivityUnit> activities) {
        ArrayList<ActivityUnit> ret = new ArrayList<ActivityUnit>();
        for (ActivityUnit au : activities) {
            if (!this.evaluate(au)) continue;
            ret.add(au);
        }
        return ret;
    }

    protected boolean evaluate(ActivityUnit au) {
        boolean ret = true;
        if (this._id != null && !this._id.equals(au.getId())) {
            ret = false;
        } else if (this._fromTimestamp != 0L && au.getActivityTypes().size() > 0 && this._fromTimestamp > au.getActivityTypes().get(au.getActivityTypes().size() - 1).getTimestamp()) {
            ret = false;
        } else if (this._toTimestamp != 0L && au.getActivityTypes().size() > 0 && this._toTimestamp < au.getActivityTypes().get(0).getTimestamp()) {
            ret = false;
        }
        if (ret && this._contexts.size() > 0) {
            boolean onematch = false;
            for (Context c : this._contexts) {
                if (au.getContext().contains(c)) {
                    onematch = true;
                    if (this._contextAND) continue;
                    break;
                }
                if (!this._contextAND) continue;
                ret = false;
                break;
            }
            if (!this._contextAND && !onematch) {
                ret = false;
            }
        }
        return ret;
    }

    public String toString() {
        return "QuerySpec[id=" + this._id + " from=" + this._fromTimestamp + " to=" + this._toTimestamp + " contexts=" + this._contexts + " contextAND=" + this._contextAND + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this._id);
        out.writeLong(this._fromTimestamp);
        out.writeLong(this._toTimestamp);
        out.writeInt(this._contexts.size());
        for (int i = 0; i < this._contexts.size(); ++i) {
            out.writeObject(this._contexts.get(i));
        }
        out.writeBoolean(this._contextAND);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._id = (String)in.readObject();
        this._fromTimestamp = in.readLong();
        this._toTimestamp = in.readLong();
        int num = in.readInt();
        for (int i = 0; i < num; ++i) {
            this._contexts.add((Context)in.readObject());
        }
        this._contextAND = in.readBoolean();
    }
}

