/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;
import org.overlord.bam.activity.model.ActivityUnit;
import org.overlord.bam.activity.server.QuerySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActivityUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<List<ActivityUnit>> ACTIVITY_LIST = new TypeReference<List<ActivityUnit>>(){};

    private ActivityUtil() {
    }

    public static byte[] serializeActivityUnit(ActivityUnit act) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, (Object)act);
        ret = baos.toByteArray();
        baos.close();
        return ret;
    }

    public static byte[] serializeQuerySpec(QuerySpec qs) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, (Object)qs);
        ret = baos.toByteArray();
        baos.close();
        return ret;
    }

    public static String objectToJSONString(Object obj) throws Exception {
        String ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, obj);
        ret = new String(baos.toByteArray());
        baos.close();
        return ret;
    }

    public static byte[] serializeActivityUnitList(List<ActivityUnit> activities) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)baos, activities);
        ret = baos.toByteArray();
        baos.close();
        return ret;
    }

    public static ActivityUnit deserializeActivityUnit(byte[] act) throws Exception {
        ActivityUnit ret = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(act);
        ret = (ActivityUnit)MAPPER.readValue((InputStream)bais, ActivityUnit.class);
        bais.close();
        return ret;
    }

    public static QuerySpec deserializeQuerySpec(byte[] qs) throws Exception {
        QuerySpec ret = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(qs);
        ret = (QuerySpec)MAPPER.readValue((InputStream)bais, QuerySpec.class);
        bais.close();
        return ret;
    }

    public static List<ActivityUnit> deserializeActivityUnitList(byte[] act) throws Exception {
        List ret = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(act);
        ret = (List)MAPPER.readValue((InputStream)bais, ACTIVITY_LIST);
        bais.close();
        return ret;
    }

    static {
        SerializationConfig config = MAPPER.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL).withSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        MAPPER.setSerializationConfig(config);
    }
}

