/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.collector;

import java.util.PropertyResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.overlord.bam.activity.collector.ActivityCollector;
import org.overlord.bam.activity.collector.ActivityUnitLogger;
import org.overlord.bam.activity.collector.CollectorContext;
import org.overlord.bam.activity.model.ActivityType;
import org.overlord.bam.activity.model.ActivityUnit;
import org.overlord.bam.activity.model.Origin;

public class AbstractActivityCollector
implements ActivityCollector {
    private static final Logger LOG = Logger.getLogger(AbstractActivityCollector.class.getName());
    @Inject
    private CollectorContext _collectorContext = null;
    @Inject
    private ActivityUnitLogger _activityLogger = null;
    private ThreadLocal<ActivityUnit> _activityUnit = new ThreadLocal();

    @Override
    public void setCollectorContext(CollectorContext cc) {
        this._collectorContext = cc;
    }

    @Override
    public CollectorContext getCollectorContext() {
        return this._collectorContext;
    }

    @Override
    public void setActivityUnitLogger(ActivityUnitLogger activityLogger) {
        this._activityLogger = activityLogger;
    }

    @Override
    public ActivityUnitLogger getActivityUnitLogger() {
        return this._activityLogger;
    }

    protected String createTransactionId() {
        return UUID.randomUUID().toString();
    }

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }

    @Override
    public void startScope() {
        ActivityUnit au = this._activityUnit.get();
        if (au == null) {
            this.startScope(this.createActivityUnit());
        }
    }

    @Override
    public boolean isScopeActive() {
        return this._activityUnit.get() != null;
    }

    protected void startScope(ActivityUnit au) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Start scope");
        }
        this._activityUnit.set(au);
    }

    protected ActivityUnit createActivityUnit() {
        ActivityUnit ret = new ActivityUnit();
        Origin origin = new Origin();
        origin.setHost(this._collectorContext.getHost());
        origin.setNode(this._collectorContext.getNode());
        origin.setPort(this._collectorContext.getPort());
        origin.setPrincipal(this._collectorContext.getPrincipal());
        origin.setThread(Thread.currentThread().getName());
        ret.setOrigin(origin);
        return ret;
    }

    @Override
    public void endScope() {
        ActivityUnit au = this._activityUnit.get();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("End scope for: " + au);
        }
        if (au != null) {
            this._activityLogger.log(au);
            this._activityUnit.remove();
        } else {
            LOG.severe(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-1"));
        }
    }

    @Override
    public void record(ActivityType actType) {
        boolean transactional;
        ActivityUnit au;
        block9: {
            au = this._activityUnit.get();
            transactional = true;
            if (au == null) {
                au = this.createActivityUnit();
                TransactionManager tm = this._collectorContext.getTransactionManager();
                if (tm != null) {
                    try {
                        Transaction txn = tm.getTransaction();
                        if (txn != null) {
                            txn.registerSynchronization(new Synchronization(){

                                public void afterCompletion(int arg0) {
                                    AbstractActivityCollector.this.endScope();
                                }

                                public void beforeCompletion() {
                                }
                            });
                            this.startScope(au);
                            break block9;
                        }
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("No transaction available");
                        }
                        transactional = false;
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-2"), e);
                        transactional = false;
                    }
                } else {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("No transaction manager available");
                    }
                    transactional = false;
                }
            }
        }
        actType.setTimestamp(this.getTimestamp());
        au.getActivityTypes().add(actType);
        if (!transactional) {
            this._activityLogger.log(au);
        }
    }
}

