/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.overlord.bam.activity.model.ActivityTypeId;
import org.overlord.bam.activity.model.Context;
import org.overlord.bam.activity.model.bpm.ProcessCompleted;
import org.overlord.bam.activity.model.bpm.ProcessStarted;
import org.overlord.bam.activity.model.mom.MessageReceived;
import org.overlord.bam.activity.model.mom.MessageSent;
import org.overlord.bam.activity.model.soa.RequestReceived;
import org.overlord.bam.activity.model.soa.RequestSent;
import org.overlord.bam.activity.model.soa.ResponseReceived;
import org.overlord.bam.activity.model.soa.ResponseSent;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=MessageReceived.class), @JsonSubTypes.Type(value=MessageSent.class), @JsonSubTypes.Type(value=RequestReceived.class), @JsonSubTypes.Type(value=RequestSent.class), @JsonSubTypes.Type(value=ResponseReceived.class), @JsonSubTypes.Type(value=ResponseSent.class), @JsonSubTypes.Type(value=ProcessCompleted.class), @JsonSubTypes.Type(value=ProcessStarted.class)})
@Entity
@IdClass(value=ActivityTypeId.class)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.STRING)
public abstract class ActivityType
implements Externalizable {
    private static final int VERSION = 1;
    private String _unitId = null;
    private int _unitIndex = 0;
    private long _timestamp = 0L;
    private List<Context> _contexts = new Vector<Context>();
    private Map<String, String> _properties = new HashMap<String, String>();

    public ActivityType() {
    }

    public ActivityType(ActivityType act) {
        this._unitId = act._unitId;
        this._unitIndex = act._unitIndex;
        this._timestamp = act._timestamp;
        for (Context ctx : act._contexts) {
            this._contexts.add(new Context(ctx));
        }
        this._properties = new HashMap<String, String>(act._properties);
    }

    public void setUnitId(String id) {
        this._unitId = id;
    }

    @Id
    @Column(name="unitId")
    public String getUnitId() {
        return this._unitId;
    }

    public void setUnitIndex(int index) {
        this._unitIndex = index;
    }

    @Id
    @Column(name="unitIndex")
    public int getUnitIndex() {
        return this._unitIndex;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setContext(List<Context> context) {
        this._contexts = context;
    }

    @ElementCollection
    public List<Context> getContext() {
        return this._contexts;
    }

    public void setProperties(Map<String, String> props) {
        this._properties = props;
    }

    @ElementCollection(targetClass=String.class)
    @MapKeyColumn(name="name")
    @Column(name="value")
    @CollectionTable(name="activity_properties", joinColumns={@JoinColumn(name="unit_id", referencedColumnName="unitId"), @JoinColumn(name="unit_index", referencedColumnName="unitIndex")})
    public Map<String, String> getProperties() {
        return this._properties;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this._unitId);
        out.writeInt(this._unitIndex);
        out.writeLong(this._timestamp);
        int len = this._contexts.size();
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeObject(this._contexts.get(i));
        }
        out.writeObject(this._properties);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._unitId = (String)in.readObject();
        this._unitIndex = in.readInt();
        this._timestamp = in.readLong();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this._contexts.add((Context)in.readObject());
        }
        this._properties = (Map)in.readObject();
    }
}

