/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.collector;

import java.util.PropertyResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.overlord.bam.activity.collector.ActivityUnitLogger;
import org.overlord.bam.activity.collector.BatchedActivityUnitLoggerMBean;
import org.overlord.bam.activity.model.ActivityUnit;

public abstract class BatchedActivityUnitLogger
implements ActivityUnitLogger,
BatchedActivityUnitLoggerMBean {
    private static final Logger LOG = Logger.getLogger(BatchedActivityUnitLogger.class.getName());
    private int _messageCounter = 0;
    private Timer _timer;
    private TimerTask _timerTask;
    private long _maxTimeInterval = 500L;
    private int _maxUnitCount = 1000;

    @Override
    @PostConstruct
    public void init() {
        this._timer = new Timer();
    }

    @Override
    public void setMaxTimeInterval(long max) {
        this._maxTimeInterval = max;
    }

    @Override
    public long getMaxTimeInterval() {
        return this._maxTimeInterval;
    }

    @Override
    public void setMaxUnitCount(int max) {
        this._maxUnitCount = max;
    }

    @Override
    public int getMaxUnitCount() {
        return this._maxUnitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(ActivityUnit act) {
        try {
            Timer timer = this._timer;
            synchronized (timer) {
                if (this._timerTask == null) {
                    this._timerTask = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Timer timer = BatchedActivityUnitLogger.this._timer;
                                synchronized (timer) {
                                    BatchedActivityUnitLogger.this.sendMessage();
                                    BatchedActivityUnitLogger.this.reset();
                                }
                            }
                            catch (Exception e) {
                                LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-3"), e);
                            }
                        }
                    };
                    this._timer.schedule(this._timerTask, this._maxTimeInterval);
                }
                this.appendActivity(act);
                ++this._messageCounter;
                if (this._messageCounter > this._maxUnitCount) {
                    this.sendMessage();
                    this.reset();
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-3"), e);
        }
    }

    protected abstract void appendActivity(ActivityUnit var1) throws Exception;

    protected abstract void sendMessage() throws Exception;

    protected void reset() {
        this._messageCounter = 0;
        if (this._timerTask != null) {
            this._timerTask.cancel();
            this._timerTask = null;
        }
    }

    @Override
    @PreDestroy
    public void close() {
        this._timer.cancel();
    }
}

