/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.bam.activity.model.ActivityType;
import org.overlord.bam.activity.model.Context;
import org.overlord.bam.activity.processor.ExpressionEvaluator;
import org.overlord.bam.activity.processor.ScriptEvaluator;

public class TypeProcessor {
    private static final Logger LOG = Logger.getLogger(TypeProcessor.class.getName());
    private ExpressionEvaluator _representation = null;
    private List<ContextEvaluator> _contextEvaluators = new ArrayList<ContextEvaluator>();
    private List<PropertyEvaluator> _propertyEvaluators = new ArrayList<PropertyEvaluator>();
    private ScriptEvaluator _scriptEvaluator = null;

    public void init() throws Exception {
        if (this._representation != null) {
            this._representation.init();
        }
        for (ContextEvaluator ce : this._contextEvaluators) {
            ce.getEvaluator().init();
        }
        for (PropertyEvaluator pe : this._propertyEvaluators) {
            pe.getEvaluator().init();
        }
        if (this._scriptEvaluator != null) {
            this._scriptEvaluator.init();
        }
    }

    public ExpressionEvaluator getRepresentation() {
        return this._representation;
    }

    public void setRepresentation(ExpressionEvaluator rep) {
        this._representation = rep;
    }

    public List<ContextEvaluator> getContexts() {
        return this._contextEvaluators;
    }

    public void setContexts(List<ContextEvaluator> ce) {
        this._contextEvaluators = ce;
    }

    public List<PropertyEvaluator> getProperties() {
        return this._propertyEvaluators;
    }

    public void setProperties(List<PropertyEvaluator> pe) {
        this._propertyEvaluators = pe;
    }

    public ScriptEvaluator getScript() {
        return this._scriptEvaluator;
    }

    public void setScript(ScriptEvaluator script) {
        this._scriptEvaluator = script;
    }

    public String process(Object information, ActivityType actType) {
        String val;
        int i;
        String ret = null;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Process information: " + information);
        }
        for (i = 0; i < this._contextEvaluators.size(); ++i) {
            ContextEvaluator ce = this._contextEvaluators.get(i);
            val = ce.getEvaluator().evaluate(information);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Context evaluator '" + ce + "' = " + val);
            }
            if (val == null) continue;
            actType.getContext().add(new Context(ce.getType(), val));
        }
        for (i = 0; i < this._propertyEvaluators.size(); ++i) {
            PropertyEvaluator pe = this._propertyEvaluators.get(i);
            val = pe.getEvaluator().evaluate(information);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Property evaluator '" + pe + "' = " + val);
            }
            if (val == null) continue;
            actType.getProperties().put(pe.getName(), val);
        }
        if (this.getScript() != null) {
            this.getScript().evaluate(information, actType);
        }
        if (this.getRepresentation() != null) {
            ret = this.getRepresentation().evaluate(information);
        }
        return ret;
    }

    public void close() throws Exception {
        if (this._representation != null) {
            this._representation.close();
        }
        for (ContextEvaluator ce : this._contextEvaluators) {
            ce.getEvaluator().close();
        }
        for (PropertyEvaluator pe : this._propertyEvaluators) {
            pe.getEvaluator().close();
        }
        if (this._scriptEvaluator != null) {
            this._scriptEvaluator.close();
        }
    }

    public static class ContextEvaluator {
        private Context.Type _type = null;
        private ExpressionEvaluator _evaluator = null;

        public Context.Type getType() {
            return this._type;
        }

        public void setType(Context.Type type) {
            this._type = type;
        }

        public ExpressionEvaluator getEvaluator() {
            return this._evaluator;
        }

        public void setEvaluator(ExpressionEvaluator evaluator) {
            this._evaluator = evaluator;
        }

        public String toString() {
            return "[ type=" + (Object)((Object)this._type) + " expression=" + this._evaluator.getExpression() + " ]";
        }
    }

    public static class PropertyEvaluator {
        private String _name = null;
        private ExpressionEvaluator _evaluator = null;

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public ExpressionEvaluator getEvaluator() {
            return this._evaluator;
        }

        public void setEvaluator(ExpressionEvaluator evaluator) {
            this._evaluator = evaluator;
        }

        public String toString() {
            return "[ name=" + this._name + " expression=" + this._evaluator.getExpression() + " ]";
        }
    }
}

