/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.karaf.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.gogo.commands.Command;
import org.overlord.commons.codec.AesEncrypter;
import org.overlord.commons.karaf.commands.configure.AbstractConfigureCommand;
import org.overlord.dtgov.karaf.commands.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="overlord:dtgov", name="configure")
public class ConfigureCommand
extends AbstractConfigureCommand {
    private static final Logger logger = LoggerFactory.getLogger(ConfigureCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        logger.info(Messages.getString("configure.command.executed"));
        super.doExecute();
        logger.debug(Messages.getString("configure.command.copying.files"));
        this.copyFile("dtgov-ui.properties");
        this.copyFile("dtgov.properties");
        File dir = new File(this.karafConfigPath + "overlord-apps");
        if (!dir.exists()) {
            dir.mkdir();
        }
        this.copyFile("dtgovui-overlordapp.properties", "overlord-apps/dtgovui-overlordapp.properties");
        logger.debug(Messages.getString("configure.command.copying.files.end"));
        String randomWorkflowUserPassword = UUID.randomUUID().toString();
        logger.debug(Messages.getString("configure.command.adding.jms.user"));
        Properties usersProperties = new Properties();
        File srcFile = new File(this.karafConfigPath + "users.properties");
        FileInputStream fis = new FileInputStream(srcFile);
        try {
            usersProperties.load(fis);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
        String randomWorkflowPassword = DigestUtils.sha256Hex((String)randomWorkflowUserPassword);
        String encryptedPassword = "{CRYPT}" + randomWorkflowPassword + "{CRYPT}";
        StringBuilder workflowUserValue = new StringBuilder();
        workflowUserValue.append(encryptedPassword).append(",").append("overlorduser,admin.sramp");
        usersProperties.setProperty("dtgovworkflow", workflowUserValue.toString());
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/dtgov.properties");
        FileOutputStream os = null;
        try {
            String aesEncryptedValue = AesEncrypter.encrypt((String)randomWorkflowUserPassword);
            StringBuilder aesEncrypterBuilder = new StringBuilder();
            aesEncrypterBuilder.append("${crypt:").append(aesEncryptedValue).append("}");
            aesEncryptedValue = aesEncrypterBuilder.toString();
            Properties dtgovProps = new Properties();
            dtgovProps.load(is);
            for (Object key : dtgovProps.keySet()) {
                String value = (String)dtgovProps.get(key);
                if (!value.contains("${dtgov.users.workflow.password}")) continue;
                dtgovProps.put(key, aesEncryptedValue);
            }
            File dtgovFile = new File(this.karafConfigPath + "dtgov.properties");
            os = new FileOutputStream(dtgovFile);
            dtgovProps.store(os, "");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
        logger.debug(Messages.getString("configure.command.adding.user.end"));
        String adminUser = (String)usersProperties.get("admin");
        if (!adminUser.contains("dev,qa")) {
            adminUser = adminUser + ",dev,qa,stage,prod,ba,arch";
            usersProperties.setProperty("admin", adminUser);
        }
        logger.debug(Messages.getString("configure.command.modify.admin.roles"));
        os = new FileOutputStream(srcFile);
        try {
            usersProperties.store(os, "");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
        logger.info(Messages.getString("configure.command.end.execution"));
        return null;
    }
}

