/*
 * Copyright 2013 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.overlord.dtgov.ui.client.local.services;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

import org.jboss.errai.ioc.client.api.InitBallot;
import org.overlord.dtgov.ui.client.local.beans.UiConfiguration;
import org.overlord.dtgov.ui.server.servlets.UiConfigurationServlet;

/**
 * A configuration service that pulls its dynamic configuration data from a javascript
 * variable that it expects to be available.  This javascript variable is dynamically
 * generated by a servlet {@link UiConfigurationServlet}.  See the servlet for details.
 *
 * @author eric.wittmann@redhat.com
 */
@ApplicationScoped
public class ConfigurationService {

    @Inject
    private InitBallot<ConfigurationService> ballot;

    private UiConfiguration uiConfig;

    /**
     * Constructor.
     */
    public ConfigurationService() {
    }

    /**
     * Construct the UI configuration by reading data from the OVERLORD_DTGOVUI_CONFIG javascript
     * variable.  If this variable is not present, sensible defaults should be used.  See details
     * in {@link UiConfiguration}.
     */
    @PostConstruct
    private void onPostConstruct() {
        uiConfig = new UiConfiguration();
        ballot.voteForInit();
    }

    /**
     * @return the UI configuration bean
     */
    public UiConfiguration getUiConfig() {
        return uiConfig;
    }
}
