/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.util;

import java.io.InputStream;
import org.jbpm.kie.services.api.DeploymentUnit;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RuntimeManager;
import org.overlord.dtgov.jbpm.util.ProcessEngineService;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieSrampUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String SRAMP_KIE_JAR_QUERY_FORMAT = "/s-ramp/ext/KieJarArchive[@maven.groupId='%s' and @maven.artifactId = '%s' and @maven.version = '%s']";

    public boolean isSRAMPPackageDeployed(String groupId, String artifactId, String version) {
        try {
            SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
            String srampQuery = String.format(SRAMP_KIE_JAR_QUERY_FORMAT, groupId, artifactId, version);
            QueryResultSet results = client.query(srampQuery);
            if (results.size() > 0L) {
                return Boolean.TRUE;
            }
        }
        catch (SrampClientException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SrampAtomException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public KieContainer getKieContainer(ReleaseId releaseId) throws SrampClientException, SrampAtomException {
        KieServices ks = KieServices.Factory.get();
        KieRepository repo = ks.getRepository();
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        Governance governance = new Governance();
        String srampQuery = String.format(SRAMP_KIE_JAR_QUERY_FORMAT, governance.getGovernanceWorkflowGroup(), governance.getGovernanceWorkflowName(), governance.getGovernanceWorkflowVersion());
        QueryResultSet results = client.query(srampQuery);
        if (results.size() > 0L) {
            ArtifactSummary artifactSummery = results.get(0);
            InputStream is = client.getArtifactContent(artifactSummery);
            KieModule kModule = repo.addKieModule(ks.getResources().newInputStreamResource(is), new Resource[0]);
            this.logger.info(Messages.i18n.format("KieSrampUtil.CreatingKieContainer", new Object[]{artifactSummery}));
            KieContainer kContainer = ks.newKieContainer(kModule.getReleaseId());
            this.logger.info(Messages.i18n.format("KieSrampUtil.FindKieBase", new Object[]{governance.getGovernanceWorkflowPackage()}));
            return kContainer;
        }
        return null;
    }

    public RuntimeManager getRuntimeManager(ProcessEngineService processEngineService, String deploymentId) {
        String[] deploymentInfo = deploymentId.split(":");
        if (deploymentInfo.length != 5) {
            throw new IllegalStateException(Messages.i18n.format("KieSrampUtil.DeploymentIdFormat", new Object[0]));
        }
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit(deploymentInfo[0], deploymentInfo[1], deploymentInfo[2], deploymentInfo[3], deploymentInfo[4]);
        return this.getRuntimeManager(processEngineService, unit);
    }

    public RuntimeManager getRuntimeManager(ProcessEngineService processEngineService, KModuleDeploymentUnit unit) {
        RuntimeManager runtimeManager = processEngineService.getRuntimeManager(unit.getIdentifier());
        if (runtimeManager == null) {
            if (this.isSRAMPPackageDeployed(unit.getGroupId(), unit.getArtifactId(), unit.getVersion())) {
                unit.setStrategy(DeploymentUnit.RuntimeStrategy.PER_PROCESS_INSTANCE);
                processEngineService.deployUnit(unit);
                runtimeManager = processEngineService.getRuntimeManager(unit.getIdentifier());
                this.logger.info(Messages.i18n.format("KieSrampUtil.FoundAndDeployed", new Object[]{unit.getIdentifier()}));
            } else {
                this.logger.error(Messages.i18n.format("KieSrampUtil.NotFound", new Object[]{unit.getIdentifier()}));
                throw new IllegalStateException(Messages.i18n.format("KieSrampUtil.NotFound", new Object[]{unit.getIdentifier()}));
            }
        }
        return runtimeManager;
    }
}

