/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services;

import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.io.IOUtils;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.NotificationDestinations;
import org.overlord.sramp.governance.SlashDecoder;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.ValueEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notify")
public class NotificationResource {
    private Session mailSession;
    private static Logger logger = LoggerFactory.getLogger(NotificationResource.class);
    private Governance governance = new Governance();

    public NotificationResource() {
        try {
            String jndiEmailRef = this.governance.getJNDIEmailName();
            InitialContext context = new InitialContext();
            this.mailSession = (Session)context.lookup(jndiEmailRef);
            if (this.mailSession == null) {
                logger.error(Messages.i18n.format("NotificationResource.JndiLookupFailed", new Object[]{jndiEmailRef}));
            }
        }
        catch (NamingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @POST
    @Path(value="email/{group}/{template}/{target}/{uuid}")
    @Produces(value={"application/xml"})
    public Map<String, ValueEntity> emailNotification(@Context HttpServletRequest request, @PathParam(value="group") String group, @PathParam(value="template") String template, @PathParam(value="target") String target, @PathParam(value="uuid") String uuid) throws Exception {
        HashMap<String, ValueEntity> results = new HashMap<String, ValueEntity>();
        try {
            group = SlashDecoder.decode((String)group);
            template = SlashDecoder.decode((String)template);
            target = SlashDecoder.decode((String)target);
            uuid = SlashDecoder.decode((String)uuid);
            SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
            String query = String.format("/s-ramp[@uuid='%s']", uuid);
            QueryResultSet queryResultSet = client.query(query);
            if (queryResultSet.size() == 0L) {
                results.put("status", new ValueEntity("fail"));
                results.put("message", new ValueEntity("Could not obtain artifact from repository."));
                return results;
            }
            ArtifactSummary artifactSummary = (ArtifactSummary)queryResultSet.iterator().next();
            NotificationDestinations destinations = (NotificationDestinations)this.governance.getNotificationDestinations("email").get(group);
            if (destinations == null) {
                destinations = new NotificationDestinations(group, this.governance.getDefaultEmailFromAddress(), group + "@" + this.governance.getDefaultEmailDomain());
            }
            try {
                MimeMessage m = new MimeMessage(this.mailSession);
                InternetAddress from = new InternetAddress(destinations.getFromAddress());
                InternetAddress[] to = new InternetAddress[destinations.getToAddresses().length];
                for (int i = 0; i < destinations.getToAddresses().length; ++i) {
                    to[i] = new InternetAddress(destinations.getToAddresses()[i]);
                }
                m.setFrom((Address)from);
                m.setRecipients(Message.RecipientType.TO, (Address[])to);
                String subject = "/governance-email-templates/" + template + ".subject.tmpl";
                URL subjectUrl = Governance.class.getClassLoader().getResource(subject);
                if (subjectUrl != null) {
                    subject = IOUtils.toString((URL)subjectUrl);
                }
                subject = subject.replaceAll("\\$\\{uuid}", uuid);
                subject = subject.replaceAll("\\$\\{name}", artifactSummary.getName());
                subject = subject.replaceAll("\\$\\{target}", target);
                m.setSubject(subject);
                m.setSentDate(new Date());
                String content = "/governance-email-templates/" + template + ".body.tmpl";
                URL contentUrl = Governance.class.getClassLoader().getResource(content);
                if (contentUrl != null) {
                    content = IOUtils.toString((URL)contentUrl);
                }
                content = content.replaceAll("\\$\\{uuid}", uuid);
                content = content.replaceAll("\\$\\{name}", artifactSummary.getName());
                content = content.replaceAll("\\$\\{target}", target);
                content = content.replaceAll("\\$\\{dtgovurl}", this.governance.getDTGovUiUrl());
                m.setContent((Object)content, "text/plain");
                Transport.send((Message)m);
            }
            catch (MessagingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            results.put("status", new ValueEntity("success"));
            return results;
        }
        catch (Exception e) {
            logger.error(Messages.i18n.format("NotificationResource.EmailError", new Object[]{e.getMessage(), e}));
            throw new SrampAtomException((Throwable)e);
        }
    }
}

