/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.client.model;

import com.google.gwt.core.client.JsArray;
import java.util.ArrayList;
import java.util.List;
import org.overlord.gadgets.web.client.model.JSOModel;
import org.overlord.gadgets.web.shared.dto.PageModel;
import org.overlord.gadgets.web.shared.dto.PageResponse;
import org.overlord.gadgets.web.shared.dto.StoreItemModel;
import org.overlord.gadgets.web.shared.dto.UserModel;
import org.overlord.gadgets.web.shared.dto.UserPreference;
import org.overlord.gadgets.web.shared.dto.WidgetModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSOParser {
    public static List<PageModel> getPageModels(String jsonValue) {
        ArrayList<PageModel> pageModels = new ArrayList<PageModel>();
        JsArray tabModels = JSOModel.arrayFromJson((String)jsonValue);
        for (int i = 0; i < tabModels.length(); ++i) {
            PageModel pageModel = new PageModel();
            JSOModel pageModelValue = (JSOModel)tabModels.get(i);
            pageModel.setName(pageModelValue.get("name"));
            pageModel.setOrder(pageModelValue.getLong("order"));
            pageModel.setColumns(pageModelValue.getLong("columns"));
            pageModel.setId(pageModelValue.getLong("id"));
            JsArray widgetModels = pageModelValue.getArray("models");
            for (int j = 0; j < widgetModels.length(); ++j) {
                WidgetModel widgetModel = new WidgetModel();
                JSOModel gadgetValue = (JSOModel)widgetModels.get(j);
                widgetModel.setIframeUrl(gadgetValue.get("iframeUrl"));
                widgetModel.setName(gadgetValue.get("name"));
                widgetModel.setSpecUrl(gadgetValue.get("specUrl"));
                widgetModel.setOrder(Long.valueOf(gadgetValue.getLong("order")));
                widgetModel.setWidgetId(gadgetValue.getLong("widgetId"));
                UserPreference userPreference = new UserPreference();
                JSOModel prefValue = gadgetValue.getObject("userPreference");
                userPreference.setNeedToEdit(prefValue.getBoolean("needToEdit"));
                JsArray settings = prefValue.getArray("data");
                for (int k = 0; k < settings.length(); ++k) {
                    UserPreference.UserPreferenceSetting prefSetting = new UserPreference.UserPreferenceSetting();
                    JSOModel settingValue = (JSOModel)settings.get(k);
                    prefSetting.setDisplayName(settingValue.get("displayName"));
                    prefSetting.setDefaultValue(settingValue.get("defaultValue"));
                    prefSetting.setRequired(settingValue.getBoolean("required"));
                    prefSetting.setName(settingValue.get("name"));
                    prefSetting.setType(UserPreference.Type.valueOf((String)settingValue.get("type")));
                    JsArray options = settingValue.getArray("enumOptions");
                    for (int m = 0; m < options.length(); ++m) {
                        UserPreference.Option option = new UserPreference.Option();
                        JSOModel optionValue = (JSOModel)options.get(m);
                        option.setDisplayValue(optionValue.get("displayValue"));
                        option.setValue(optionValue.get("value"));
                        prefSetting.addEnumOption(option);
                    }
                    userPreference.addUserPreferenceSetting(prefSetting);
                }
                widgetModel.setUserPreference(userPreference);
                pageModel.addModel(widgetModel);
            }
            pageModels.add(pageModel);
        }
        return pageModels;
    }

    public static PageResponse<StoreItemModel> getStoreItems(String jsonValue) {
        JSOModel model = JSOModel.fromJson((String)jsonValue);
        JsArray resultSets = model.getArray("resultSet");
        ArrayList<StoreItemModel> items = new ArrayList<StoreItemModel>();
        for (int i = 0; i < resultSets.length(); ++i) {
            StoreItemModel itemModel = new StoreItemModel();
            JSOModel theItem = (JSOModel)resultSets.get(i);
            itemModel.setId(theItem.getLong("id"));
            itemModel.setName(theItem.get("title"));
            itemModel.setDescription(theItem.get("description"));
            itemModel.setThumbnailUrl(theItem.get("thumbnailUrl"));
            itemModel.setAuthor(theItem.get("author"));
            items.add(itemModel);
        }
        int numOfRec = model.getInt("totalResults");
        int offset = model.getInt("offset");
        int pageSize = model.getInt("pageSize");
        PageResponse response = new PageResponse(items, numOfRec);
        response.setOffset(offset);
        response.setPageSize(pageSize);
        return response;
    }

    public static UserModel getUserModel(String jsonValue) {
        JSOModel model = JSOModel.fromJson((String)jsonValue);
        UserModel user = new UserModel();
        user.setUserId(model.getLong("userId"));
        user.setUserName(model.get("userName"));
        user.setCurrentPageId(model.getLong("currentPageId"));
        user.setDisplayName(model.get("displayName"));
        return user;
    }
}

