/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.overlord.gadgets.web.client.URLBuilder;
import org.overlord.gadgets.web.client.util.RestfulInvoker;
import org.overlord.gadgets.web.client.widgets.Portlet;
import org.overlord.gadgets.web.shared.dto.UserPreference;
import org.overlord.gadgets.web.shared.dto.WidgetModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Portlet
extends Composite {
    private static PortletUiBinder uiBinder = (PortletUiBinder)GWT.create(PortletUiBinder.class);
    private static String urlBase;
    private String id;
    private String widgetId;
    private String portalId;
    private String iframeId;
    private WidgetModel wmodel;
    private String userPreferenceValues;
    private List<Widget> prefs = new ArrayList();
    @UiField
    InlineLabel minBtn;
    @UiField
    InlineLabel title;
    @UiField
    InlineLabel removeBtn;
    @UiField
    InlineLabel maxBtn;
    @UiField
    InlineLabel settingBtn;
    @UiField
    InlineLabel restoreBtn;
    @UiField
    FlowPanel userPreference;
    @UiField
    FlowPanel portletContent;
    @UiField
    Frame gadgetSpec;
    @UiField
    FlexTable prefTable;

    private Portlet(String wid, String pid) {
        this.widgetId = wid;
        this.id = "portlet-" + this.widgetId;
        this.portalId = pid;
        this.iframeId = "iframe-" + this.widgetId;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.getElement().setId(this.id);
        this.gadgetSpec.getElement().setId(this.iframeId);
        urlBase = this.getGadgetServerUrlBase();
        this.minBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.maxBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.restoreBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.settingBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.gadgetSpec.getElement().setId(this.widgetId);
    }

    public Portlet(WidgetModel model, int width, String portalId) {
        this(String.valueOf(model.getWidgetId()), portalId);
        this.title.setText(model.getName());
        this.wmodel = model;
        RestfulInvoker.invoke((RequestBuilder.Method)RequestBuilder.GET, (String)URLBuilder.getPreferenceValuesURL((long)Long.valueOf(this.widgetId)), null, (RestfulInvoker.Response)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void generatePreferenceValuesString(Map<String, String> value) {
        StringBuilder sbuilder = new StringBuilder();
        int i = 1;
        for (String key : value.keySet()) {
            sbuilder.append(key).append("=").append(value.get(key));
            if (i < value.size()) {
                sbuilder.append("&");
            }
            ++i;
        }
        this.userPreferenceValues = sbuilder.toString();
    }

    private String getGadgetServerUrlBase() {
        String gadgetWebUrlBase = GWT.getHostPageBaseURL();
        int end = gadgetWebUrlBase.indexOf("gadget-web");
        return gadgetWebUrlBase.substring(0, end);
    }

    private void generateUserPref(WidgetModel model, Map<String, String> values) {
        UserPreference pref = model.getUserPreference();
        int row = 0;
        for (UserPreference.UserPreferenceSetting prefSet : pref.getData()) {
            if (UserPreference.Type.STRING.equals((Object)prefSet.getType())) {
                this.prefTable.setWidget(row, 0, (Widget)new Label(prefSet.getDisplayName()));
                Widget textBox = this.createTextBox(prefSet.getName(), this.getDefaultValue(values, prefSet.getName(), prefSet.getDefaultValue()));
                this.prefs.add(textBox);
                this.prefTable.setWidget(row, 1, textBox);
            } else if (UserPreference.Type.ENUM.equals((Object)prefSet.getType())) {
                this.prefTable.setWidget(row, 0, (Widget)new Label(prefSet.getDisplayName()));
                ArrayList<String> options = new ArrayList<String>();
                for (UserPreference.Option option : prefSet.getEnumOptions()) {
                    options.add(option.getValue());
                }
                Widget listBox = this.createSelectBox(prefSet.getName(), this.getDefaultValue(values, prefSet.getName(), prefSet.getDefaultValue()), options);
                this.prefs.add(listBox);
                this.prefTable.setWidget(row, 1, listBox);
            } else if (UserPreference.Type.LIST.equals((Object)prefSet.getType())) {
                this.prefTable.setWidget(row, 0, (Widget)new Label(prefSet.getDisplayName()));
                Widget listBox = this.createSelectBox(prefSet.getName(), this.getDefaultValue(values, prefSet.getName(), prefSet.getDefaultValue()), prefSet.getListOptions());
                this.prefs.add(listBox);
                this.prefTable.setWidget(row, 1, listBox);
            }
            ++row;
        }
        this.prefTable.setWidget(row, 1, this.createPrefSettingButtons());
    }

    private String getDefaultValue(Map<String, String> values, String name, String defaultValue) {
        if (values.get(name) != null) {
            return values.get(name);
        }
        return defaultValue;
    }

    private Widget createTextBox(String name, String defaultVal) {
        TextBox textBox = new TextBox();
        textBox.getElement().setId(name);
        textBox.setName(name);
        textBox.setValue((Object)defaultVal);
        return textBox;
    }

    private Widget createSelectBox(String name, String defaultVal, List<String> options) {
        ListBox listBox = new ListBox(false);
        listBox.setName(name);
        listBox.getElement().setId(name);
        for (String option : options) {
            listBox.addItem(option);
        }
        if (options.size() == 0) {
            listBox.addItem(" ");
        }
        int index = 0;
        for (int i = 0; i < options.size(); ++i) {
            if (!options.get(i).equals(defaultVal)) continue;
            index = i;
        }
        listBox.setSelectedIndex(index);
        return listBox;
    }

    private Widget createPrefSettingButtons() {
        HorizontalPanel btnPanel = new HorizontalPanel();
        Button saveBtn = new Button("Save");
        saveBtn.getElement().setId("pref-save");
        Button cancelBtn = new Button("Cancel");
        btnPanel.add((Widget)saveBtn);
        saveBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        btnPanel.add((Widget)cancelBtn);
        cancelBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return btnPanel;
    }

    public String getHomeView() {
        return "view=home";
    }

    public String getCanvasView() {
        return "view=canvas";
    }

    public void onAttach() {
        super.onAttach();
        Portlet.hideRestoreButton((String)this.id);
        Portlet.hideUserPref((String)this.id);
    }

    private static native void toggle(String var0);

    private static native void remove(String var0);

    private static native void showUserPreference(String var0);

    private static native void hideRestoreButton(String var0);

    private static native void showRestoreButton(String var0);

    private static native void maximizeWindow(String var0, String var1);

    private static native void restoreWindow(String var0);

    private static native void hideUserPref(String var0);

    private static native void showUserPref(String var0);

    private static native void reloadIFrame(String var0);

    private static native void reloadGadget(String var0, String var1);

    private static native void setPreference(String var0, String var1);

    static /* synthetic */ String access$000(Portlet x0) {
        return x0.id;
    }

    static /* synthetic */ void access$100(String x0) {
        Portlet.toggle((String)x0);
    }

    static /* synthetic */ String access$200(Portlet x0) {
        return x0.widgetId;
    }

    static /* synthetic */ void access$300(String x0) {
        Portlet.remove((String)x0);
    }

    static /* synthetic */ String access$400(Portlet x0) {
        return x0.portalId;
    }

    static /* synthetic */ void access$500(String x0, String x1) {
        Portlet.maximizeWindow((String)x0, (String)x1);
    }

    static /* synthetic */ void access$600(String x0) {
        Portlet.hideUserPref((String)x0);
    }

    static /* synthetic */ void access$700(String x0) {
        Portlet.showRestoreButton((String)x0);
    }

    static /* synthetic */ String access$800() {
        return urlBase;
    }

    static /* synthetic */ WidgetModel access$900(Portlet x0) {
        return x0.wmodel;
    }

    static /* synthetic */ String access$1000(Portlet x0) {
        return x0.userPreferenceValues;
    }

    static /* synthetic */ void access$1100(String x0) {
        Portlet.restoreWindow((String)x0);
    }

    static /* synthetic */ void access$1200(String x0) {
        Portlet.hideRestoreButton((String)x0);
    }

    static /* synthetic */ void access$1300(String x0) {
        Portlet.showUserPref((String)x0);
    }

    static /* synthetic */ void access$1400(Portlet x0, WidgetModel x1, Map x2) {
        x0.generateUserPref(x1, x2);
    }

    static /* synthetic */ void access$1500(Portlet x0, Map x1) {
        x0.generatePreferenceValuesString(x1);
    }

    static /* synthetic */ List access$1600(Portlet x0) {
        return x0.prefs;
    }

    static /* synthetic */ String access$1002(Portlet x0, String x1) {
        x0.userPreferenceValues = x1;
        return x0.userPreferenceValues;
    }

    static /* synthetic */ void access$1700(String x0, String x1) {
        Portlet.reloadGadget((String)x0, (String)x1);
    }
}

