/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server;

import java.util.Iterator;
import org.jboss.resteasy.client.ClientRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.overlord.gadgets.server.model.Gadget;
import org.overlord.gadgets.web.server.GadgetMetadataService;
import org.overlord.gadgets.web.shared.dto.UserPreference;
import org.overlord.gadgets.web.shared.dto.WidgetModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShindigGadgetMetadataService
implements GadgetMetadataService {
    private static Logger logger = LoggerFactory.getLogger(ShindigGadgetMetadataService.class);
    public static final String USER_PREFS = "userPrefs";
    public static final String DATA_TYPE = "dataType";
    private String rpcUrl = "http://localhost:8080/gadget-server/rpc";

    public void setGadgetServerRPCUrl(String rpcUrl) {
        this.rpcUrl = rpcUrl;
    }

    public WidgetModel getGadgetMetadata(String gadgetUrl) {
        String responseString = this.getMetadata(gadgetUrl);
        logger.debug("gadget url is: " + gadgetUrl + ", gadget metadata is: " + responseString);
        try {
            JSONObject responseObject = new JSONArray(responseString).getJSONObject(0).getJSONObject("result").getJSONObject(gadgetUrl);
            WidgetModel model = new WidgetModel();
            model.setIframeUrl("http:" + responseObject.getString("iframeUrl"));
            model.setName(responseObject.getJSONObject("modulePrefs").getString("title"));
            model.setSpecUrl(gadgetUrl);
            logger.debug(responseObject.toString());
            boolean hasPrefsToEdit = false;
            if (responseObject.has(USER_PREFS)) {
                UserPreference userPref = new UserPreference();
                JSONObject userPrefs = responseObject.getJSONObject(USER_PREFS);
                Iterator keys = userPrefs.keys();
                while (keys.hasNext()) {
                    String settingName = (String)keys.next();
                    UserPreference.UserPreferenceSetting theSetting = new UserPreference.UserPreferenceSetting();
                    JSONObject setting = userPrefs.getJSONObject(settingName);
                    String theType = setting.getString(DATA_TYPE);
                    if (!UserPreference.Type.HIDDEN.toString().equals(theType)) {
                        hasPrefsToEdit = true;
                    }
                    theSetting.setName(setting.getString("name"));
                    theSetting.setDefaultValue(setting.getString("defaultValue"));
                    theSetting.setDisplayName(setting.getString("displayName"));
                    theSetting.setRequired(Boolean.valueOf(setting.getString("required")).booleanValue());
                    theSetting.setType(UserPreference.Type.valueOf((String)theType));
                    if (setting.has("orderedEnumValues")) {
                        JSONArray enumValues = setting.getJSONArray("orderedEnumValues");
                        for (int i = 0; i < enumValues.length(); ++i) {
                            UserPreference.Option option = new UserPreference.Option();
                            JSONObject theOption = enumValues.getJSONObject(i);
                            option.setValue(theOption.getString("value"));
                            option.setDisplayValue(theOption.getString("displayValue"));
                            theSetting.addEnumOption(option);
                        }
                    }
                    userPref.addUserPreferenceSetting(theSetting);
                }
                userPref.setNeedToEdit(hasPrefsToEdit);
                model.setUserPreference(userPref);
            }
            return model;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Error occurred while processing response from shindig metadata call", e);
        }
    }

    private String getMetadata(String gadgetUrl) {
        JSONArray rpcArray = new JSONArray();
        try {
            JSONObject fetchMetadataRpcOperation = new JSONObject().put("method", (Object)"gadgets.metadata").put("id", (Object)"gadgets.metadata").put("params", (Object)new JSONObject().put("container", (Object)"default").put("view", (Object)"home").put("st", (Object)"default").put("debug", true).append("ids", (Object)gadgetUrl).append("fields", (Object)"iframeUrl").append("fields", (Object)"modulePrefs.*").append("fields", (Object)"needsTokenRefresh").append("fields", (Object)"userPrefs.*").append("fields", (Object)"views.preferredHeight").append("fields", (Object)"views.preferredWidth").append("fields", (Object)"expireTimeMs").append("fields", (Object)"responseTimeMs").put("userId", (Object)"@viewer").put("groupId", (Object)"@self"));
            rpcArray.put((Object)fetchMetadataRpcOperation);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Error occurred while generating data for shindig metadata call", e);
        }
        String postData = rpcArray.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("requestContent: {}", (Object)postData);
        }
        ClientRequest request = new ClientRequest(this.rpcUrl);
        request.accept("application/json").body("application/json", (Object)postData);
        String responseString = null;
        try {
            responseString = (String)request.postTarget(String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return responseString;
    }

    public Gadget getGadgetData(String gadgetUrl) {
        String responseString = this.getMetadata(gadgetUrl);
        try {
            JSONObject responseObject = new JSONArray(responseString).getJSONObject(0).getJSONObject("result").getJSONObject(gadgetUrl);
            JSONObject modulePref = responseObject.getJSONObject("modulePrefs");
            Gadget gadget = new Gadget();
            gadget.setTitle(modulePref.getString("title"));
            gadget.setScreenshotUrl(modulePref.getString("screenshot"));
            gadget.setAuthorEmail(modulePref.getString("authorEmail"));
            gadget.setAuthor(modulePref.getString("author"));
            gadget.setTitleUrl(modulePref.getString("titileUrl"));
            gadget.setThumbnailUrl(modulePref.getString("thumbnail"));
            gadget.setDescription(modulePref.getString("description"));
            return gadget;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Error occurred while processing response from shindig metadata call", e);
        }
    }

    public static void main(String[] args) throws Exception {
        ShindigGadgetMetadataService svc = new ShindigGadgetMetadataService();
        svc.getGadgetMetadata("http://rt-gadget.googlecode.com/git/gadget.xml");
    }
}

