/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.overlord.gadgets.web.client.URLBuilder;
import org.overlord.gadgets.web.client.auth.CurrentUser;
import org.overlord.gadgets.web.client.util.RestfulInvoker;
import org.overlord.gadgets.web.client.widgets.ListItem;
import org.overlord.gadgets.web.client.widgets.PortalLayout;
import org.overlord.gadgets.web.client.widgets.TabLayout;
import org.overlord.gadgets.web.client.widgets.UnorderedList;

/*
 * Exception performing whole class analysis ignored.
 */
public class TabLayout
extends Composite {
    private static TabLayoutUiBinder uiBinder = (TabLayoutUiBinder)GWT.create(TabLayoutUiBinder.class);
    private String id;
    private String promptId;
    @UiField
    UnorderedList tabsBar;
    @UiField
    FlowPanel tabsContent;
    @UiField
    DivElement tabs;
    @UiField
    DivElement promptDiv;
    private ListItem addTabAnchorItem;
    private CurrentUser currentUser;
    private Map<String, String> tabNames = new HashMap();
    private Map<String, String> indexIdMap = new HashMap();
    private static int index = 0;

    public TabLayout(CurrentUser user) {
        this.currentUser = user;
        this.id = "gadget-web-tabs";
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.tabs.setId(this.id);
        this.promptId = "gadget-web-tabs-prompt";
        this.promptDiv.setId(this.promptId);
    }

    public void addTab(String pageId, String tabTitle, PortalLayout widget) {
        String tabContentId = this.getTabContentId(pageId);
        this.tabNames.put(tabContentId, tabTitle);
        this.addTabTitle(tabTitle, tabContentId);
        widget.addClosingDiv();
        FlowPanel theContent = new FlowPanel();
        theContent.getElement().setId(tabContentId);
        theContent.add((Widget)widget);
        this.tabsContent.add((Widget)theContent);
        this.indexIdMap.put(String.valueOf(index), pageId);
        ++index;
    }

    public void setTabAnchor(Anchor anchor) {
        this.addTabAnchorItem = new ListItem();
        this.addTabAnchorItem.add((Widget)anchor);
        this.tabsBar.add((Widget)this.addTabAnchorItem);
    }

    public void addTabAnchor() {
        this.tabsBar.add((Widget)this.addTabAnchorItem);
    }

    private void addTabTitle(String tabTitle, String tabContentId) {
        ListItem li = new ListItem();
        li.getElement().setClassName("ui-state-default ui-corner-top");
        Anchor anchor = new Anchor();
        anchor.setHref("#" + tabContentId);
        anchor.setText(tabTitle);
        li.add((Widget)anchor);
        InlineLabel removeBtn = new InlineLabel();
        removeBtn.setText("remove");
        removeBtn.setStyleName("ui-icon ui-icon-close");
        li.add((Widget)removeBtn);
        this.tabsBar.add((Widget)li);
    }

    public void insertTab(String pageId, String tabTitle, Widget widget) {
        String tabContentId = this.getTabContentId(pageId);
        FlowPanel theContent = new FlowPanel();
        theContent.getElement().setId(tabContentId);
        theContent.add(widget);
        this.tabsContent.add((Widget)theContent);
        int theIndex = this.tabNames.size();
        this.tabNames.put(tabContentId, tabTitle);
        this.indexIdMap.put(String.valueOf(index), pageId);
        ++index;
        this.tabsBar.remove((Widget)this.addTabAnchorItem);
        TabLayout.addNewTab((String)this.id, (String)tabContentId, (String)tabTitle, (int)theIndex);
        this.tabsBar.add((Widget)this.addTabAnchorItem);
        this.updateUserCurrentPageId(Long.valueOf(pageId).longValue());
        TabLayout.hidePrompt((String)this.promptId);
    }

    private String getTabContentId(String pageId) {
        return "tab-content-" + pageId;
    }

    public void onAttach() {
        super.onAttach();
        if (this.currentUser.getCurrentPage() == 0L) {
            TabLayout.showPrompt((String)this.promptId);
        } else {
            TabLayout.hidePrompt((String)this.promptId);
        }
    }

    public void initializeTab() {
        TabLayout.initTabs((TabLayout)this, (String)this.id);
        TabLayout.registerCloseEvent((TabLayout)this, (String)this.id);
    }

    public void clearAllTabs() {
        for (String contentId : this.tabNames.keySet()) {
            TabLayout.removeTab((String)this.id, (String)contentId);
        }
        this.tabsBar.remove((Widget)this.addTabAnchorItem);
        TabLayout.destroyTab((String)this.id);
        index = 0;
    }

    private void setCurrentPage(Long indexId) {
        String theIndexId = String.valueOf(indexId);
        String pageId = (String)this.indexIdMap.get(theIndexId);
        long thePageId = Long.valueOf(pageId);
        this.updateUserCurrentPageId(thePageId);
    }

    private void removePage(Long indexId) {
        String theIndexId = String.valueOf(indexId);
        String pageId = (String)this.indexIdMap.get(theIndexId);
        RestfulInvoker.invoke((RequestBuilder.Method)RequestBuilder.POST, (String)URLBuilder.getRemovePageURL((long)Long.valueOf(pageId)), null, (RestfulInvoker.Response)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void selectCurrentActiveTab() {
        String tabContentId = this.getTabContentId(String.valueOf(this.currentUser.getCurrentPage()));
        TabLayout.selectTab((String)this.id, (String)tabContentId);
    }

    private void updateUserCurrentPageId(long pageId) {
        RestfulInvoker.invoke((RequestBuilder.Method)RequestBuilder.POST, (String)URLBuilder.updateCurrentPageId((long)this.currentUser.getUserId(), (long)pageId), null, (RestfulInvoker.Response)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static native void initTabs(TabLayout var0, String var1);

    private static native void selectTab(String var0, String var1);

    private static native void addNewTab(String var0, String var1, String var2, int var3);

    private static native void removeTab(String var0, String var1);

    private static native void destroyTab(String var0);

    private static native void hidePrompt(String var0);

    private static native void showPrompt(String var0);

    private static native void registerCloseEvent(TabLayout var0, String var1);

    static /* synthetic */ Map access$000(TabLayout x0) {
        return x0.indexIdMap;
    }

    static /* synthetic */ void access$100(TabLayout x0, long x1) {
        x0.updateUserCurrentPageId(x1);
    }

    static /* synthetic */ String access$200(TabLayout x0) {
        return x0.promptId;
    }

    static /* synthetic */ void access$300(String x0) {
        TabLayout.showPrompt((String)x0);
    }

    static /* synthetic */ CurrentUser access$400(TabLayout x0) {
        return x0.currentUser;
    }
}

