/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.servlet.GadgetsHandler;
import org.apache.shindig.gadgets.servlet.GadgetsHandlerApi;
import org.apache.shindig.protocol.BaseRequestItem;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.json.JSONException;
import org.json.JSONObject;
import org.overlord.gadgets.server.model.Gadget;
import org.overlord.gadgets.web.server.GadgetMetadataService;
import org.overlord.gadgets.web.shared.dto.UserPreference;
import org.overlord.gadgets.web.shared.dto.WidgetModel;

public class ShindigGadgetMetadataService
implements GadgetMetadataService {
    public static final String USER_PREFS = "userPrefs";
    public static final String DATA_TYPE = "dataType";
    @Inject
    private GadgetsHandler gadgetsHandler;
    @Inject
    @Named(value="shindig.bean.converter.json")
    protected BeanConverter jsonConverter;

    public WidgetModel getGadgetMetadata(String gadgetUrl) {
        try {
            GadgetsHandlerApi.MetadataResponse metaDataFromShindig = this.getMetaDataFromShindig(gadgetUrl);
            WidgetModel model = new WidgetModel();
            model.setIframeUrl("http:" + metaDataFromShindig.getIframeUrl());
            model.setName(metaDataFromShindig.getModulePrefs().getTitle());
            model.setSpecUrl(gadgetUrl);
            boolean hasPrefsToEdit = false;
            if (metaDataFromShindig.getUserPrefs() != null && metaDataFromShindig.getUserPrefs().size() > 0) {
                UserPreference userPref = new UserPreference();
                Map userPrefs = metaDataFromShindig.getUserPrefs();
                for (String settingName : userPrefs.keySet()) {
                    UserPreference.UserPreferenceSetting theSetting = new UserPreference.UserPreferenceSetting();
                    GadgetsHandlerApi.UserPref setting = (GadgetsHandlerApi.UserPref)userPrefs.get(settingName);
                    String theType = String.valueOf(setting.getDataType());
                    if (!UserPreference.Type.HIDDEN.toString().equals(theType)) {
                        hasPrefsToEdit = true;
                    }
                    theSetting.setName(setting.getName());
                    theSetting.setDefaultValue(setting.getDefaultValue());
                    theSetting.setDisplayName(setting.getDisplayName());
                    theSetting.setRequired(setting.getRequired());
                    theSetting.setType(UserPreference.Type.valueOf((String)theType));
                    List enumValues = setting.getOrderedEnumValues();
                    if (enumValues != null && enumValues.size() > 0) {
                        for (GadgetsHandlerApi.EnumValuePair enumValuePair : enumValues) {
                            UserPreference.Option option = new UserPreference.Option();
                            option.setValue(enumValuePair.getValue());
                            option.setDisplayValue(enumValuePair.getDisplayValue());
                            theSetting.addEnumOption(option);
                        }
                    }
                    userPref.addUserPreferenceSetting(theSetting);
                }
                userPref.setNeedToEdit(hasPrefsToEdit);
                model.setUserPreference(userPref);
            }
            return model;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Error occurred while processing response from shindig metadata call", e);
        }
    }

    public Gadget getGadgetData(String gadgetUrl) {
        try {
            GadgetsHandlerApi.MetadataResponse metaDataFromShindig = this.getMetaDataFromShindig(gadgetUrl);
            GadgetsHandlerApi.ModulePrefs modulePref = metaDataFromShindig.getModulePrefs();
            Gadget gadget = new Gadget();
            gadget.setTitle(modulePref.getTitle());
            if (modulePref.getScreenshot() != null) {
                gadget.setScreenshotUrl(String.valueOf(modulePref.getScreenshot()));
            }
            gadget.setAuthorEmail(modulePref.getAuthorEmail());
            gadget.setAuthor(modulePref.getAuthor());
            if (modulePref.getTitleUrl() != null) {
                gadget.setTitleUrl(modulePref.getTitleUrl().toString());
            }
            if (modulePref.getThumbnail() != null) {
                gadget.setThumbnailUrl(modulePref.getThumbnail().toString());
            }
            gadget.setDescription(modulePref.getDescription());
            return gadget;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Error occurred while processing response from shindig metadata call", e);
        }
    }

    private GadgetsHandlerApi.MetadataResponse getMetaDataFromShindig(String gadgetUrl) throws JSONException {
        AnonymousSecurityToken securityToken;
        JSONObject params = new JSONObject().put("container", (Object)"default").put("view", (Object)"home").put("st", (Object)"default").put("debug", true).append("ids", (Object)gadgetUrl).append("fields", (Object)"iframeUrl").append("fields", (Object)"modulePrefs.*").append("fields", (Object)"needsTokenRefresh").append("fields", (Object)"userPrefs.*").append("fields", (Object)"views.preferredHeight").append("fields", (Object)"views.preferredWidth").append("fields", (Object)"expireTimeMs").append("fields", (Object)"responseTimeMs").put("userId", (Object)"@viewer").put("groupId", (Object)"@self");
        BaseRequestItem request = new BaseRequestItem(params, new HashMap(), (SecurityToken)(securityToken = new AnonymousSecurityToken()), this.jsonConverter, (BeanJsonConverter)this.jsonConverter);
        Map responses = this.gadgetsHandler.metadata(request);
        GadgetsHandlerApi.BaseResponse response = (GadgetsHandlerApi.BaseResponse)responses.get(gadgetUrl);
        if (response instanceof GadgetsHandlerApi.MetadataResponse) {
            return (GadgetsHandlerApi.MetadataResponse)response;
        }
        GadgetsHandlerApi.Error error = response.getError();
        if (error != null) {
            throw new JSONException(error.getMessage());
        }
        throw new JSONException("Unknown error:" + response.getUrl());
    }
}

