/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server.http;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.HashSet;
import java.util.Set;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.BasicHttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.overlord.gadgets.web.server.http.auth.AuthenticationProvider;

@Singleton
public class AuthenticatingHttpFetcher
extends BasicHttpFetcher {
    @Inject
    private AuthenticationProvider authenticationProvider;
    private final Set<String> authEndpoints = new HashSet();

    @Inject
    public AuthenticatingHttpFetcher(@Nullable @Named(value="org.apache.shindig.gadgets.http.basicHttpFetcherProxy") String basicHttpFetcherProxy, @Named(value="gadget-server.config.auth.endpoints") String endpoints) {
        super(basicHttpFetcherProxy);
        this.parseEndpoints(endpoints);
    }

    private void parseEndpoints(String endpoints) {
        if (endpoints != null) {
            String[] split;
            for (String endpoint : split = endpoints.split(",")) {
                this.authEndpoints.add(endpoint.trim());
            }
        }
    }

    public AuthenticatingHttpFetcher(int maxObjSize, int connectionTimeoutMs, int readTimeoutMs, String basicHttpFetcherProxy) {
        super(maxObjSize, connectionTimeoutMs, readTimeoutMs, basicHttpFetcherProxy);
    }

    public HttpResponse fetch(HttpRequest request) throws GadgetException {
        if (request.getOAuthArguments() == null && request.getOAuth2Arguments() == null && this.isAuthEndpoint(request)) {
            this.authenticationProvider.provideAuthentication(request);
        }
        return super.fetch(request);
    }

    private boolean isAuthEndpoint(HttpRequest request) {
        Uri uri = request.getUri();
        String path = uri.getPath();
        for (String authEndpoint : this.authEndpoints) {
            if (!path.startsWith(authEndpoint)) continue;
            return true;
        }
        return false;
    }
}

