/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server.http.auth;

import com.google.inject.Binder;
import com.google.inject.name.Names;
import java.util.Properties;
import java.util.Set;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.overlord.gadgets.server.ConfiguredModule;
import org.overlord.gadgets.web.server.http.AuthenticatingHttpFetcher;
import org.overlord.gadgets.web.server.http.auth.AuthenticationProvider;

public class AuthenticationModule
extends ConfiguredModule {
    protected void configure() {
        Properties names = new Properties();
        Set<Object> keySet = properties.keySet();
        for (Object object : keySet) {
            String key = String.valueOf(object);
            if (!key.startsWith("gadget-server.config.auth")) continue;
            names.put(key, properties.getProperty(key, ""));
        }
        Names.bindProperties((Binder)this.binder(), (Properties)names);
        this.bind(HttpFetcher.class).to(AuthenticatingHttpFetcher.class);
        String authProviderClassname = properties.getProperty("gadget-server.config.auth.provider");
        if (authProviderClassname != null) {
            try {
                Class<?> c = Class.forName(authProviderClassname);
                if (AuthenticationProvider.class.isAssignableFrom(c)) {
                    this.bind(AuthenticationProvider.class).to(c);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

