/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server.listeners;

import com.google.inject.Binding;
import com.google.inject.Injector;
import java.lang.reflect.Type;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.ws.rs.ext.Provider;
import org.apache.shindig.common.servlet.GuiceServletContextListener;
import org.jboss.resteasy.plugins.guice.GuiceResourceFactory;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;

public class ShindigResteasyBootstrapServletContextListener
extends ResteasyBootstrap
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent event) {
        super.contextInitialized(event);
        ServletContext context = event.getServletContext();
        Injector injector = (Injector)context.getAttribute("guice-injector");
        if (injector == null && (injector = (Injector)context.getAttribute(GuiceServletContextListener.INJECTOR_NAME)) == null) {
            throw new RuntimeException("Guice Injector not found! Make sure you registered " + GuiceServletContextListener.class.getName() + " as a listener");
        }
        Registry registry = (Registry)context.getAttribute(Registry.class.getName());
        ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)context.getAttribute(ResteasyProviderFactory.class.getName());
        this.processInjector(injector, registry, providerFactory);
    }

    private void processInjector(Injector injector, Registry registry, ResteasyProviderFactory providerFactory) {
        for (Binding binding : injector.getBindings().values()) {
            Type type = binding.getKey().getTypeLiteral().getType();
            if (!(type instanceof Class)) continue;
            Class beanClass = (Class)type;
            if (GetRestful.isRootResource((Class)beanClass)) {
                GuiceResourceFactory resourceFactory = new GuiceResourceFactory(binding.getProvider(), beanClass);
                registry.addResourceFactory((ResourceFactory)resourceFactory);
            }
            if (!beanClass.isAnnotationPresent(Provider.class)) continue;
            providerFactory.registerProviderInstance(binding.getProvider().get());
        }
    }
}

