/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.sample.shiro;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import org.apache.shindig.social.sample.spi.JsonDbOpensocialService;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class SampleShiroRealm
extends AuthorizingRealm {
    @Inject
    private static JsonDbOpensocialService jsonDbService;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        String username = upToken.getUsername();
        if (username == null) {
            throw new AccountException("Null usernames are not allowed by this realm.");
        }
        String password = jsonDbService.getPassword(username);
        return new SimpleAuthenticationInfo((Object)username, (Object)password, this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            throw new AuthorizationException("PrincipalCollection method argument cannot be null.");
        }
        String username = (String)principals.fromRealm(this.getName()).iterator().next();
        ImmutableSet roleNames = username == null ? ImmutableSet.of() : ImmutableSet.of((Object)"foo", (Object)"goo");
        return new SimpleAuthorizationInfo((Set)roleNames);
    }
}

