/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.client.view;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.inject.Inject;
import com.gwtplatform.mvp.client.ViewImpl;
import java.util.List;
import org.overlord.gadgets.web.client.ApplicationEntryPoint;
import org.overlord.gadgets.web.client.BootstrapContext;
import org.overlord.gadgets.web.client.auth.CurrentUser;
import org.overlord.gadgets.web.client.presenter.IndexPresenter;
import org.overlord.gadgets.web.client.widgets.AddTabForm;
import org.overlord.gadgets.web.client.widgets.PortalLayout;
import org.overlord.gadgets.web.client.widgets.Portlet;
import org.overlord.gadgets.web.client.widgets.TabLayout;
import org.overlord.gadgets.web.shared.dto.PageModel;
import org.overlord.gadgets.web.shared.dto.WidgetModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexViewImpl
extends ViewImpl
implements IndexPresenter.IndexView {
    private LayoutPanel headerPanel;
    private LayoutPanel mainPanel;
    private TabLayout mainContentPanel;
    private LayoutPanel footerPanel;
    private DockLayoutPanel panel;
    private BootstrapContext context;
    private IndexPresenter presenter;
    private CurrentUser currentUser;

    @Inject
    public IndexViewImpl(BootstrapContext ctx, CurrentUser user) {
        this.context = ctx;
        this.currentUser = user;
        this.headerPanel = new LayoutPanel();
        this.headerPanel.setStyleName("header-panel");
        HTML store = new HTML("Gadget Store");
        store.addStyleName("header-link");
        store.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.headerPanel.add((Widget)store);
        this.headerPanel.setWidgetRightWidth((Widget)store, 5.0, Style.Unit.PX, 110.0, Style.Unit.PX);
        this.headerPanel.setWidgetTopHeight((Widget)store, 5.0, Style.Unit.PX, 28.0, Style.Unit.PX);
        this.footerPanel = new LayoutPanel();
        this.footerPanel.setStyleName("footer-panel");
        this.panel = new DockLayoutPanel(Style.Unit.PX);
        this.panel.getElement().setAttribute("id", "container");
        this.mainContentPanel = new TabLayout(this.currentUser);
        AddTabForm addTabForm = new AddTabForm(this.currentUser, this.mainContentPanel);
        Anchor anchor = new Anchor();
        anchor.setText("+");
        anchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.mainContentPanel.setTabAnchor(anchor);
        this.mainPanel = new LayoutPanel();
        this.mainPanel.add((Widget)addTabForm);
        this.mainPanel.add((Widget)this.mainContentPanel);
        this.panel.addNorth((Widget)this.headerPanel, 25.0);
        this.panel.addSouth((Widget)this.footerPanel, 25.0);
        this.panel.add((Widget)this.mainPanel);
        this.footerPanel.add(ApplicationEntryPoint.MODULES.getFooter().asWidget());
    }

    public void initializePages(List<PageModel> pageModels) {
        this.mainContentPanel.clearAllTabs();
        for (PageModel page : pageModels) {
            int i = 0;
            int columnNum = Long.valueOf(page.getColumns()).intValue();
            PortalLayout portalLayout = new PortalLayout(String.valueOf(page.getId()), columnNum);
            for (WidgetModel model : page.getModels()) {
                portalLayout.addPortlet(i % columnNum, (Widget)new Portlet(model, portalLayout.getPortletWidth(), portalLayout.getPortalId()));
                ++i;
            }
            this.mainContentPanel.addTab(String.valueOf(page.getId()), page.getName(), portalLayout);
        }
        this.mainContentPanel.addTabAnchor();
        this.mainContentPanel.initializeTab();
        this.mainContentPanel.selectCurrentActiveTab();
    }

    public Widget asWidget() {
        return this.panel;
    }

    public void setPresenter(IndexPresenter presenter) {
        this.presenter = presenter;
    }

    private static native void alertWindow(String var0);

    static /* synthetic */ CurrentUser access$000(IndexViewImpl x0) {
        return x0.currentUser;
    }
}

