/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server;

import com.google.inject.Inject;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.overlord.gadgets.server.model.Gadget;
import org.overlord.gadgets.server.model.Page;
import org.overlord.gadgets.server.service.GadgetService;
import org.overlord.gadgets.server.service.UserManager;
import org.overlord.gadgets.web.shared.dto.PageResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/stores")
public class StoreController {
    @Inject
    GadgetService gadgetService;
    @Inject
    UserManager userManager;

    @Inject
    public StoreController() {
    }

    @GET
    @Path(value="all/{offset}/{pageSize}")
    @Produces(value={"application/json"})
    public PageResponse<Gadget> getGadgets(@PathParam(value="offset") int offset, @PathParam(value="pageSize") int pageSize) {
        List gadgets = this.gadgetService.getAllGadgets(offset, pageSize);
        int number = this.gadgetService.getAllGadgetsNum();
        PageResponse result = new PageResponse(gadgets, number);
        return result;
    }

    @POST
    @Path(value="page/{pageId}/gadget/{gadgetId}")
    @Produces(value={"application/json"})
    public Response addGadgetToPage(@PathParam(value="pageId") long pageId, @PathParam(value="gadgetId") long gadgetId) {
        Gadget gadget = this.gadgetService.getGadgetById(gadgetId);
        Page page = this.userManager.getPage(pageId);
        this.gadgetService.addGadgetToPage(gadget, page);
        return Response.ok().build();
    }
}

