/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.shared.dto;

import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageResponse<T>
implements Serializable {
    private static final long serialVersionUID = 2412181515947943577L;
    private List<T> resultSet;
    private int totalResults;
    private int pageSize;
    private int offset;

    public PageResponse(List<T> resultset, int totalResults) {
        this.resultSet = resultset;
        this.totalResults = totalResults;
        this.pageSize = 10;
        this.offset = 0;
    }

    public List<T> getResultSet() {
        return this.resultSet;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getNumberOfPages() {
        if (this.pageSize == 0) {
            return 0;
        }
        int numberOfPages = this.totalResults / this.pageSize;
        if (this.totalResults % this.pageSize > 0) {
            ++numberOfPages;
        }
        return numberOfPages;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getCurrentPage() {
        if (this.isFirstPage()) {
            return 1;
        }
        return this.offset / this.pageSize + 1;
    }

    private boolean isFirstPage() {
        return this.offset == 0 || this.pageSize == 0 || this.totalResults < this.pageSize;
    }
}

