/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.jetty8;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.overlord.commons.auth.jetty8.JettyAuthConstants;
import org.overlord.commons.auth.util.IRoleGenerator;

@Component(name="The jetty 8 Role Generator", immediate=true)
@Service(value={IRoleGenerator.class})
public class Jetty8RoleGenerator
implements IRoleGenerator {
    public boolean accept() {
        try {
            Class.forName("org.eclipse.jetty.server.Request");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public Set<String> generateRoles(HttpServletRequest request) {
        try {
            Request jettyRequest = (Request)request;
            Authentication authentication = jettyRequest.getAuthentication();
            Authentication.User userAuth = (Authentication.User)authentication;
            UserIdentity userIdentity = userAuth.getUserIdentity();
            Subject subject = userIdentity.getSubject();
            HashSet<String> roles = new HashSet<String>();
            for (String cname : JettyAuthConstants.ROLE_CLASSES) {
                try {
                    Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(cname);
                    Set<?> principals = subject.getPrincipals(c);
                    for (Principal p : principals) {
                        roles.add(p.getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            return roles;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

