/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.jetty8;

import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.overlord.commons.auth.filters.SamlBearerTokenAuthFilter;
import org.overlord.commons.auth.filters.SimplePrincipal;
import org.overlord.commons.auth.jetty8.JettyAuthConstants;

@Deprecated
public class Jetty8SamlBearerTokenAuthFilter
extends SamlBearerTokenAuthFilter {
    public static final ThreadLocal<SimplePrincipal> TL_principal = new ThreadLocal();
    private String[] roleClasses;

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.roleClasses = null;
        String parameter = config.getInitParameter("roleClasses");
        this.roleClasses = parameter != null && parameter.trim().length() > 0 ? parameter.split(",") : this.defaultRoleClasses();
    }

    protected String[] defaultRoleClasses() {
        return JettyAuthConstants.ROLE_CLASSES;
    }

    protected SimplePrincipal login(SamlBearerTokenAuthFilter.Creds credentials, HttpServletRequest request, HttpServletResponse response) throws IOException {
        SimplePrincipal principal = super.login(credentials, request, response);
        TL_principal.set(principal);
        return principal;
    }

    protected SimplePrincipal doBasicLogin(String username, String password, HttpServletRequest request) throws IOException {
        ServletContext context = request.getServletContext();
        ServletContextHandler.Context jettyCtx = (ServletContextHandler.Context)context;
        ConstraintSecurityHandler securityHandler = (ConstraintSecurityHandler)jettyCtx.getContextHandler().getChildHandlerByClass(ConstraintSecurityHandler.class);
        if (securityHandler == null) {
            return null;
        }
        LoginService loginService = securityHandler.getLoginService();
        if (loginService == null) {
            return null;
        }
        UserIdentity identity = loginService.login(username, (Object)password);
        if (identity == null) {
            return null;
        }
        SimplePrincipal principal = new SimplePrincipal(username);
        for (String cname : this.roleClasses) {
            try {
                Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(cname);
                Set<?> principals = identity.getSubject().getPrincipals(c);
                for (Principal p : principals) {
                    principal.addRole(p.getName());
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return principal;
    }

    protected void doFilterChain(ServletRequest request, ServletResponse response, FilterChain chain, SimplePrincipal principal) throws IOException, ServletException {
        super.doFilterChain(request, response, chain, principal);
        TL_principal.remove();
    }
}

