/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.dev.server.discovery;

import java.io.File;
import org.overlord.commons.dev.server.DevServerModule;
import org.overlord.commons.dev.server.discovery.AbstractModuleDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.ModuleDiscoveryContext;

public class WebAppModuleFromIDEDiscoveryStrategy
extends AbstractModuleDiscoveryStrategy {
    private final Class<?> someClass;

    public WebAppModuleFromIDEDiscoveryStrategy(Class<?> someClass) {
        this.someClass = someClass;
    }

    @Override
    public String getName() {
        return "IDE";
    }

    @Override
    public DevServerModule discover(ModuleDiscoveryContext context) {
        String path = this.someClass.getClassLoader().getResource(this.someClass.getName().replace('.', '/') + ".class").getPath();
        if (path == null) {
            return null;
        }
        this.debug("Path: " + path);
        File file = new File(path);
        if (file.exists()) {
            if (path.contains("/WEB-INF/classes/")) {
                String pathToWebApp = path.substring(0, path.indexOf("/WEB-INF/classes/"));
                this.debug("Path to web app: " + pathToWebApp);
                DevServerModule module = new DevServerModule();
                module.setInIDE(true);
                module.setModuleDir(new File(pathToWebApp));
                return module;
            }
            if (path.contains("/target/classes/")) {
                String pathToWebApp = path.substring(0, path.indexOf("/target/classes/")) + "/src/main/webapp";
                this.debug("Path to web app: " + pathToWebApp);
                DevServerModule module = new DevServerModule();
                module.setInIDE(true);
                module.setModuleDir(new File(pathToWebApp));
                return module;
            }
        }
        return null;
    }
}

