/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.acs.loader.jee;

import java.io.InputStream;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import org.overlord.rtgov.active.collection.AbstractACSLoader;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;
import org.overlord.rtgov.active.collection.ActiveCollectionManagerAccessor;
import org.overlord.rtgov.active.collection.ActiveCollectionSource;
import org.overlord.rtgov.active.collection.util.ActiveCollectionUtil;

@ApplicationScoped
@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class JEEACSLoader
extends AbstractACSLoader {
    private static final Logger LOG = Logger.getLogger(JEEACSLoader.class.getName());
    private static final String ACS_JSON = "acs.json";
    private ActiveCollectionManager _acmManager = null;
    private List<ActiveCollectionSource> _activeCollectionSources = null;

    @PostConstruct
    public void init() {
        this._acmManager = ActiveCollectionManagerAccessor.getActiveCollectionManager();
        if (this._acmManager == null) {
            LOG.severe("Failed to obtain reference to ActiveCollectionManager");
            throw new IllegalStateException("Failed to obtain reference to ActiveCollectionManager");
        }
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(ACS_JSON);
            if (is == null) {
                LOG.severe(PropertyResourceBundle.getBundle("acs-loader-jee.Messages").getString("ACS-LOADER-JEE-1"));
            } else {
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                this._activeCollectionSources = ActiveCollectionUtil.deserializeACS((byte[])b);
                if (this._activeCollectionSources == null) {
                    LOG.severe(PropertyResourceBundle.getBundle("acs-loader-jee.Messages").getString("ACS-LOADER-JEE-2"));
                } else {
                    for (ActiveCollectionSource acs : this._activeCollectionSources) {
                        this.preInit(acs);
                        this._acmManager.register(acs);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("acs-loader-jee.Messages").getString("ACS-LOADER-JEE-3"), e);
        }
    }

    @PreDestroy
    public void close() {
        block4: {
            if (this._acmManager != null && this._activeCollectionSources != null) {
                try {
                    for (ActiveCollectionSource acs : this._activeCollectionSources) {
                        this._acmManager.unregister(acs);
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.FINER)) break block4;
                    LOG.log(Level.FINER, PropertyResourceBundle.getBundle("acs-loader-jee.Messages").getString("ACS-LOADER-JEE-4"), t);
                }
            }
        }
    }
}

