/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.acs.loader.osgi;

import java.io.InputStream;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.overlord.commons.services.ServiceListener;
import org.overlord.commons.services.ServiceRegistryUtil;
import org.overlord.rtgov.active.collection.AbstractACSLoader;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;
import org.overlord.rtgov.active.collection.ActiveCollectionSource;
import org.overlord.rtgov.active.collection.util.ActiveCollectionUtil;

public class ACSActivator
extends AbstractACSLoader
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(ACSActivator.class.getName());
    private static final String ACS_JSON = "/acs.json";
    private List<ActiveCollectionSource> _activeCollectionSources = null;
    private ServiceListener<ActiveCollectionManager> _listener;

    public void start(BundleContext context) throws Exception {
        this._listener = new ServiceListener<ActiveCollectionManager>(){

            public void registered(ActiveCollectionManager service) {
                ACSActivator.this.registerActiveCollectionSource(service);
            }

            public void unregistered(ActiveCollectionManager service) {
                ACSActivator.this.unregisterActiveCollectionSource(service);
            }
        };
        ServiceRegistryUtil.addServiceListener(ActiveCollectionManager.class, this._listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerActiveCollectionSource(ActiveCollectionManager acmManager) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Register ActiveCollectionSource");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            InputStream is = ACSActivator.class.getResourceAsStream(ACS_JSON);
            if (is == null) {
                LOG.severe(PropertyResourceBundle.getBundle("acs-loader-osgi.Messages").getString("ACS-LOADER-OSGI-1"));
            } else {
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                Thread.currentThread().setContextClassLoader(ACSActivator.class.getClassLoader());
                this._activeCollectionSources = ActiveCollectionUtil.deserializeACS((byte[])b);
                if (this._activeCollectionSources == null) {
                    LOG.severe(PropertyResourceBundle.getBundle("acs-loader-osgi.Messages").getString("ACS-LOADER-OSGI-2"));
                } else {
                    for (ActiveCollectionSource acs : this._activeCollectionSources) {
                        this.preInit(acs);
                        acmManager.register(acs);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("acs-loader-osgi.Messages").getString("ACS-LOADER-OSGI-3"), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    protected void unregisterActiveCollectionSource(ActiveCollectionManager acmManager) {
        block5: {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Unregister ActiveCollectionSource");
            }
            if (acmManager != null && this._activeCollectionSources != null) {
                try {
                    for (ActiveCollectionSource acs : this._activeCollectionSources) {
                        acmManager.unregister(acs);
                    }
                    this._activeCollectionSources = null;
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.FINER)) break block5;
                    LOG.log(Level.FINER, PropertyResourceBundle.getBundle("acs-loader-osgi.Messages").getString("ACS-LOADER-OSGI-4"), t);
                }
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        ActiveCollectionManager acManager;
        if (this._activeCollectionSources != null && (acManager = (ActiveCollectionManager)ServiceRegistryUtil.getSingleService(ActiveCollectionManager.class)) != null) {
            this.unregisterActiveCollectionSource(acManager);
        }
        ServiceRegistryUtil.removeServiceListener(this._listener);
        this._listener = null;
    }
}

