/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection.jee;

import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.overlord.rtgov.active.collection.ActiveChangeListener;
import org.overlord.rtgov.active.collection.ActiveCollection;
import org.overlord.rtgov.active.collection.ActiveCollectionListener;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;
import org.overlord.rtgov.active.collection.jee.ACManagementMBean;
import org.overlord.rtgov.active.collection.jmx.JMXNotifier;

@Singleton(name="ACManagement")
@ApplicationScoped
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class ACManagement
extends NotificationBroadcasterSupport
implements ACManagementMBean,
ActiveCollectionListener {
    private static final String OBJECT_NAME_DOMAIN = "overlord.rtgov.collections";
    private static final String OBJECT_NAME_MANAGER = ":name=CollectionManager";
    private static final Logger LOG = Logger.getLogger(ACManagement.class.getName());
    @Inject
    private ActiveCollectionManager _acManager;

    @PostConstruct
    public void init() {
        LOG.info("Register the ACManagement MBean: " + this._acManager);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objname = new ObjectName("overlord.rtgov.collections:name=CollectionManager");
            mbs.registerMBean(this, objname);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("active-collection-jee.Messages").getString("ACTIVE-COLLECTION-JEE-1"), e);
        }
        this._acManager.addActiveCollectionListener((ActiveCollectionListener)this);
    }

    @PreDestroy
    public void close() throws Exception {
        LOG.info("Unregister the ACManagement MBean");
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objname = new ObjectName("overlord.rtgov.collections:name=CollectionManager");
            mbs.unregisterMBean(objname);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("active-collection-jee.Messages").getString("ACTIVE-COLLECTION-JEE-3"), e);
        }
    }

    public void registered(ActiveCollection ac) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(ac, this.getObjectName(ac));
            for (ActiveChangeListener l : ac.getActiveChangeListeners()) {
                if (!(l instanceof JMXNotifier)) continue;
                mbs.registerMBean(l, new ObjectName(((JMXNotifier)l).getObjectName()));
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("active-collection-jee.Messages").getString("ACTIVE-COLLECTION-JEE-4"), ac.getName()), e);
        }
    }

    protected ObjectName getObjectName(ActiveCollection ac) throws Exception {
        return new ObjectName("overlord.rtgov.collections:name=" + ac.getName());
    }

    public void unregistered(ActiveCollection ac) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.unregisterMBean(this.getObjectName(ac));
            for (ActiveChangeListener l : ac.getActiveChangeListeners()) {
                if (!(l instanceof JMXNotifier)) continue;
                mbs.unregisterMBean(new ObjectName(((JMXNotifier)l).getObjectName()));
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-JEE-5"), ac.getName()), e);
        }
    }

    @Override
    public void setHouseKeepingInterval(long interval) {
        this._acManager.setHouseKeepingInterval(interval);
    }

    @Override
    public long getHouseKeepingInterval() {
        return this._acManager.getHouseKeepingInterval();
    }
}

