/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection.jmx;

import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.mvel2.MVEL;
import org.overlord.rtgov.active.collection.AbstractActiveChangeListener;
import org.overlord.rtgov.active.collection.jmx.JMXNotifierMBean;

public class JMXNotifier
extends AbstractActiveChangeListener
implements JMXNotifierMBean,
NotificationEmitter {
    private static final Logger LOG = Logger.getLogger(JMXNotifier.class.getName());
    private String _objectName = null;
    private String _insertType = null;
    private String _updateType = null;
    private String _removeType = null;
    private int _sequenceNumber = 1;
    private List<NotificationDetails> _notificationDetails = new ArrayList<NotificationDetails>();
    private String _descriptionScript = null;
    private Serializable _descriptionScriptExpression = null;
    private String _insertTypeScript = null;
    private Serializable _insertTypeScriptExpression = null;
    private String _updateTypeScript = null;
    private Serializable _updateTypeScriptExpression = null;
    private String _removeTypeScript = null;
    private Serializable _removeTypeScriptExpression = null;
    private boolean _preinitialized = false;

    public void setObjectName(String name) {
        this._objectName = name;
    }

    @Override
    public String getObjectName() {
        return this._objectName;
    }

    public void setDescriptionScript(String script) {
        this._descriptionScript = script;
    }

    public String getDescriptionScript() {
        return this._descriptionScript;
    }

    public void setInsertType(String type) {
        this._insertType = type;
    }

    public String getInsertType() {
        return this._insertType;
    }

    public void setInsertTypeScript(String script) {
        this._insertTypeScript = script;
    }

    public String getInsertTypeScript() {
        return this._insertTypeScript;
    }

    public void setUpdateType(String type) {
        this._updateType = type;
    }

    public String getUpdateType() {
        return this._updateType;
    }

    public void setUpdateTypeScript(String script) {
        this._updateTypeScript = script;
    }

    public String getUpdateTypeScript() {
        return this._updateTypeScript;
    }

    public void setRemoveType(String type) {
        this._removeType = type;
    }

    public String getRemoveType() {
        return this._removeType;
    }

    public void setRemoveTypeScript(String script) {
        this._removeTypeScript = script;
    }

    public String getRemoveTypeScript() {
        return this._removeTypeScript;
    }

    @Override
    protected void preInit() throws Exception {
        super.preInit();
        if (!this._preinitialized) {
            byte[] b;
            InputStream is;
            this._preinitialized = true;
            if (this._descriptionScript != null && this._descriptionScriptExpression == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._descriptionScript);
                if (is == null) {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-1"), this._descriptionScript));
                } else {
                    b = new byte[is.available()];
                    is.read(b);
                    is.close();
                    this._descriptionScriptExpression = MVEL.compileExpression((String)new String(b));
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Pre-Initialized description script=" + this._descriptionScript + " compiled=" + this._descriptionScriptExpression);
                    }
                }
            }
            if (this._insertTypeScript != null && this._insertTypeScriptExpression == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._insertTypeScript);
                if (is == null) {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-1"), this._insertTypeScript));
                } else {
                    b = new byte[is.available()];
                    is.read(b);
                    is.close();
                    this._insertTypeScriptExpression = MVEL.compileExpression((String)new String(b));
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Pre-Initialized insert type script=" + this._insertTypeScript + " compiled=" + this._insertTypeScriptExpression);
                    }
                }
            }
            if (this._updateTypeScript != null && this._updateTypeScriptExpression == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._updateTypeScript);
                if (is == null) {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-1"), this._updateTypeScript));
                } else {
                    b = new byte[is.available()];
                    is.read(b);
                    is.close();
                    this._updateTypeScriptExpression = MVEL.compileExpression((String)new String(b));
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Pre-Initialized update type script=" + this._updateTypeScript + " compiled=" + this._updateTypeScriptExpression);
                    }
                }
            }
            if (this._removeTypeScript != null && this._removeTypeScriptExpression == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._removeTypeScript);
                if (is == null) {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-1"), this._removeTypeScript));
                } else {
                    b = new byte[is.available()];
                    is.read(b);
                    is.close();
                    this._removeTypeScriptExpression = MVEL.compileExpression((String)new String(b));
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Pre-Initialized remove type script=" + this._removeTypeScript + " compiled=" + this._removeTypeScriptExpression);
                    }
                }
            }
        }
    }

    protected String getDescription(Object value) {
        String description = value.toString();
        if (this._descriptionScriptExpression != null) {
            description = (String)MVEL.executeExpression((Object)this._descriptionScriptExpression, (Object)value);
        }
        return description;
    }

    protected String getInsertType(Object value) {
        String type = this._insertType;
        if (type == null && this._insertTypeScriptExpression != null) {
            type = (String)MVEL.executeExpression((Object)this._insertTypeScriptExpression, (Object)value);
        }
        return type;
    }

    @Override
    public void inserted(Object key, Object value) {
        String type = this.getInsertType(value);
        if (type != null) {
            Notification notification = new Notification(type, (Object)this, (long)this._sequenceNumber++, this.getDescription(value));
            for (NotificationDetails n : this._notificationDetails) {
                n.getListener().handleNotification(notification, n.getHandback());
            }
        }
    }

    protected String getUpdateType(Object value) {
        String type = this._updateType;
        if (type == null && this._updateTypeScriptExpression != null) {
            type = (String)MVEL.executeExpression((Object)this._updateTypeScriptExpression, (Object)value);
        }
        return type;
    }

    @Override
    public void updated(Object key, Object value) {
        String type = this.getUpdateType(value);
        if (type != null) {
            Notification notification = new Notification(type, (Object)this, (long)this._sequenceNumber++, this.getDescription(value));
            for (NotificationDetails n : this._notificationDetails) {
                n.getListener().handleNotification(notification, n.getHandback());
            }
        }
    }

    protected String getRemoveType(Object value) {
        String type = this._removeType;
        if (type == null && this._removeTypeScriptExpression != null) {
            type = (String)MVEL.executeExpression((Object)this._removeTypeScriptExpression, (Object)value);
        }
        return type;
    }

    @Override
    public void removed(Object key, Object value) {
        String type = this.getRemoveType(value);
        if (type != null) {
            Notification notification = new Notification(type, (Object)this, (long)this._sequenceNumber++, this.getDescription(value));
            for (NotificationDetails n : this._notificationDetails) {
                n.getListener().handleNotification(notification, n.getHandback());
            }
        }
    }

    @Override
    public void addNotificationListener(NotificationListener l, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this._notificationDetails.add(new NotificationDetails(l, filter, handback));
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    public void removeNotificationListener(NotificationListener l) throws ListenerNotFoundException {
        for (int i = this._notificationDetails.size(); i >= 0; --i) {
            NotificationDetails n = this._notificationDetails.get(i);
            if (n.getListener() != l) continue;
            this._notificationDetails.remove(i);
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener l, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        for (int i = this._notificationDetails.size(); i >= 0; --i) {
            NotificationDetails n = this._notificationDetails.get(i);
            if (n.getListener() != l || n.getFilter() != filter || n.getHandback() != handback) continue;
            this._notificationDetails.remove(i);
        }
    }

    protected class NotificationDetails {
        private NotificationListener _listener = null;
        private NotificationFilter _filter = null;
        private Object _handback = null;

        public NotificationDetails(NotificationListener listener, NotificationFilter filter, Object handback) {
            this._listener = listener;
            this._filter = filter;
            this._handback = handback;
        }

        public NotificationListener getListener() {
            return this._listener;
        }

        public NotificationFilter getFilter() {
            return this._filter;
        }

        public Object getHandback() {
            return this._handback;
        }
    }
}

