/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection.service;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.active.collection.ActiveCollection;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;
import org.overlord.rtgov.active.collection.ActiveCollectionManagerAccessor;
import org.overlord.rtgov.active.collection.ActiveList;
import org.overlord.rtgov.active.collection.ActiveMap;
import org.overlord.rtgov.common.service.Service;

public class ActiveCollectionService
extends Service {
    private static final Logger LOG = Logger.getLogger(ActiveCollectionService.class.getName());
    private static ActiveCollectionManager _activeCollectionManager;
    private boolean _initialized = false;

    public void init() throws Exception {
        super.init();
        if (_activeCollectionManager == null) {
            _activeCollectionManager = ActiveCollectionManagerAccessor.getActiveCollectionManager();
        }
    }

    protected void setActiveCollectionManager(ActiveCollectionManager acm) {
        _activeCollectionManager = acm;
    }

    protected ActiveCollection getActiveCollection(String name) {
        if (!this._initialized) {
            try {
                this.init();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to initialize active collection for retrieve list '" + name + "'", e);
            }
        }
        if (_activeCollectionManager != null) {
            return _activeCollectionManager.getActiveCollection(name);
        }
        return null;
    }

    public ActiveList getList(String name) {
        return (ActiveList)this.getActiveCollection(name);
    }

    public ActiveMap getMap(String name) {
        return (ActiveMap)this.getActiveCollection(name);
    }
}

