/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection;

import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.commons.services.ServiceClose;
import org.overlord.commons.services.ServiceInit;
import org.overlord.rtgov.active.collection.ActiveCollection;
import org.overlord.rtgov.active.collection.ActiveCollectionContext;
import org.overlord.rtgov.active.collection.ActiveCollectionListener;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;
import org.overlord.rtgov.active.collection.ActiveCollectionSource;
import org.overlord.rtgov.active.collection.DefaultActiveCollectionContext;
import org.overlord.rtgov.active.collection.predicate.Predicate;
import org.overlord.rtgov.common.util.RTGovProperties;
import org.overlord.rtgov.internal.active.collection.ACManagement;

public abstract class AbstractActiveCollectionManager
implements ActiveCollectionManager {
    private static final Logger LOG = Logger.getLogger(AbstractActiveCollectionManager.class.getName());
    private static final long HOUSE_KEEPING_INTERVAL = 10000L;
    private Map<String, ActiveCollection> _activeCollections = new HashMap<String, ActiveCollection>();
    private Map<String, ActiveCollectionSource> _activeCollectionSources = new HashMap<String, ActiveCollectionSource>();
    private Map<String, SoftReference<ActiveCollection>> _derivedActiveCollections = new HashMap<String, SoftReference<ActiveCollection>>();
    private Map<String, ActiveCollection> _derivedActiveCollectionsRetain = new HashMap<String, ActiveCollection>();
    private List<ActiveCollectionListener> _activeCollectionListeners = new ArrayList<ActiveCollectionListener>();
    private Long _houseKeepingInterval;
    private HouseKeeper _houseKeeper = null;
    private ActiveCollectionContext _context = new DefaultActiveCollectionContext(this);
    private ACManagement _management;

    public AbstractActiveCollectionManager() {
        this._houseKeepingInterval = RTGovProperties.getPropertyAsLong((String)"ActiveCollectionManager.houseKeepingInterval", (Long)10000L);
    }

    @ServiceInit
    public void init() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Initialize active collection manager");
        }
        this._houseKeeper = new HouseKeeper();
        this._management = new ACManagement(this);
        this._management.init();
    }

    @Override
    public void setHouseKeepingInterval(long interval) {
        this._houseKeepingInterval = interval;
    }

    @Override
    public long getHouseKeepingInterval() {
        if (this._houseKeepingInterval == null) {
            return 10000L;
        }
        return this._houseKeepingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ActiveCollectionSource acs) throws Exception {
        ActiveCollection ac = null;
        Object object = this._activeCollections;
        synchronized (object) {
            if (this._activeCollectionSources.containsKey(acs.getName())) {
                throw new IllegalArgumentException("Active collection source already exists for '" + acs.getName() + "'");
            }
            acs.init(this._context);
            this._activeCollectionSources.put(acs.getName(), acs);
            LOG.info("Registered active collection source '" + acs.getName() + "'");
            if (!acs.getLazy()) {
                ac = acs.getActiveCollection();
                this._activeCollections.put(acs.getName(), ac);
                if (acs.getDerivedActiveCollections().size() > 0) {
                    for (ActiveCollection dac : acs.getDerivedActiveCollections()) {
                        this._derivedActiveCollectionsRetain.put(dac.getName(), dac);
                    }
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Registered active collection '" + acs.getName() + "' immediately");
                }
            }
        }
        if (ac != null) {
            object = this._activeCollectionListeners;
            synchronized (object) {
                for (int i = 0; i < this._activeCollectionListeners.size(); ++i) {
                    this._activeCollectionListeners.get(i).registered(ac);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ActiveCollectionSource acs) throws Exception {
        ActiveCollection ac = null;
        Map<String, ActiveCollection> map = this._activeCollections;
        synchronized (map) {
            ac = this._activeCollections.remove(acs.getName());
            if (ac != null) {
                List<ActiveCollectionListener> list = this._activeCollectionListeners;
                synchronized (list) {
                    for (int i = 0; i < this._activeCollectionListeners.size(); ++i) {
                        this._activeCollectionListeners.get(i).unregistered(ac);
                    }
                }
            }
            if (!this._activeCollectionSources.containsKey(acs.getName())) {
                throw new IllegalArgumentException("Active collection '" + acs.getName() + "' is not registered");
            }
            acs.close();
            acs.setActiveCollection(null);
            this._activeCollectionSources.remove(acs.getName());
            for (ActiveCollection dac : acs.getDerivedActiveCollections()) {
                this._derivedActiveCollectionsRetain.remove(dac.getName());
            }
        }
        LOG.info("Unregistered active collection for source '" + acs.getName() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActiveCollection getActiveCollection(String name) {
        ActiveCollection ret = null;
        Map<String, Object> map = this._activeCollections;
        synchronized (map) {
            ret = this._activeCollections.get(name);
            if (ret == null) {
                if (this._activeCollectionSources.containsKey(name)) {
                    ActiveCollectionSource acs = this._activeCollectionSources.get(name);
                    ret = acs.getActiveCollection();
                    if (ret != null) {
                        this._activeCollections.put(acs.getName(), ret);
                        if (acs.getDerivedActiveCollections().size() > 0) {
                            for (ActiveCollection dac : acs.getDerivedActiveCollections()) {
                                this._derivedActiveCollectionsRetain.put(dac.getName(), dac);
                            }
                        }
                        List<ActiveCollectionListener> list = this._activeCollectionListeners;
                        synchronized (list) {
                            for (int i = 0; i < this._activeCollectionListeners.size(); ++i) {
                                this._activeCollectionListeners.get(i).registered(ret);
                            }
                        }
                    }
                } else {
                    ret = this._derivedActiveCollectionsRetain.get(name);
                }
            }
        }
        if (ret == null) {
            map = this._derivedActiveCollections;
            synchronized (map) {
                SoftReference<ActiveCollection> ref = this._derivedActiveCollections.get(name);
                if (ref != null) {
                    ret = ref.get();
                }
            }
        }
        return ret;
    }

    @Override
    public Collection<ActiveCollection> getActiveCollections() {
        return Collections.synchronizedMap(this._activeCollections).values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActiveCollection create(String name, ActiveCollection parent, Predicate predicate, Map<String, Object> properties) {
        ActiveCollection ret = null;
        Map<String, SoftReference<ActiveCollection>> map = this._derivedActiveCollections;
        synchronized (map) {
            SoftReference<ActiveCollection> ref = this._derivedActiveCollections.get(name);
            if (ref != null && (ret = ref.get()) == null) {
                this._derivedActiveCollections.remove(name);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Removing soft reference to active collection '" + name + "'");
                }
            }
            if (ret == null) {
                ret = parent.derive(name, this._context, predicate, properties);
                this._derivedActiveCollections.put(name, new SoftReference<ActiveCollection>(ret));
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Derived active collection '" + name + "' with predicate: " + predicate);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String name) {
        Map<String, SoftReference<ActiveCollection>> map = this._derivedActiveCollections;
        synchronized (map) {
            this._derivedActiveCollections.remove(name);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Removed derived active collection '" + name + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Running active collection cleanup ....");
        }
        Map<String, ActiveCollection> map = this._activeCollections;
        synchronized (map) {
            for (ActiveCollectionSource acs : this._activeCollectionSources.values()) {
                if (!acs.hasActiveCollection()) continue;
                ActiveCollection ac = acs.getActiveCollection();
                try {
                    ac.cleanup();
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-3"), ac.getName()), e);
                }
                if (ac.getHighWaterMark() <= 0) continue;
                if (ac.getHighWaterMarkWarningIssued()) {
                    if (ac.getSize() >= ac.getHighWaterMark()) continue;
                    LOG.info("Active collection '" + ac.getName() + "' has returned below its high water mark (" + ac.getHighWaterMark() + ")");
                    ac.setHighWaterMarkWarningIssued(false);
                    continue;
                }
                if (ac.getSize() <= ac.getHighWaterMark()) continue;
                LOG.warning("Active collection '" + ac.getName() + "' has exceeded its high water mark (" + ac.getHighWaterMark() + ")");
                ac.setHighWaterMarkWarningIssued(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActiveCollectionListener(ActiveCollectionListener l) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Register active collection listener=" + l);
        }
        List<ActiveCollectionListener> list = this._activeCollectionListeners;
        synchronized (list) {
            this._activeCollectionListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActiveCollectionListener(ActiveCollectionListener l) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unregister active collection listener=" + l);
        }
        List<ActiveCollectionListener> list = this._activeCollectionListeners;
        synchronized (list) {
            this._activeCollectionListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ServiceClose
    public void close() {
        int i;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Close active collection manager");
        }
        if (this._houseKeeper != null) {
            this._houseKeeper.cancel();
        }
        if (this._management != null) {
            this._management.close();
            this._management = null;
        }
        Object object = this._activeCollectionListeners;
        synchronized (object) {
            for (i = this._activeCollectionListeners.size() - 1; i >= 0; --i) {
                this.removeActiveCollectionListener(this._activeCollectionListeners.get(i));
            }
            this._activeCollectionListeners.clear();
        }
        object = this._activeCollectionSources;
        synchronized (object) {
            for (i = this._activeCollectionSources.size() - 1; i >= 0; --i) {
                ActiveCollectionSource acs = this._activeCollectionSources.get(i);
                try {
                    this.unregister(acs);
                    continue;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed to unregister active collection source '" + acs.getName() + "'", e);
                }
            }
            this._activeCollectionSources.clear();
            this._activeCollections.clear();
        }
        this._derivedActiveCollections.clear();
        this._derivedActiveCollectionsRetain.clear();
    }

    public class HouseKeeper
    extends TimerTask {
        private Timer _timer = new Timer();

        public HouseKeeper() {
            this._timer.scheduleAtFixedRate((TimerTask)this, AbstractActiveCollectionManager.this.getHouseKeepingInterval(), AbstractActiveCollectionManager.this.getHouseKeepingInterval());
        }

        @Override
        public void run() {
            AbstractActiveCollectionManager.this.cleanup();
        }
    }
}

