/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mvel2.MVEL;
import org.overlord.rtgov.active.collection.AbstractActiveChangeListener;
import org.overlord.rtgov.active.collection.ActiveCollection;
import org.overlord.rtgov.active.collection.ActiveCollectionContext;
import org.overlord.rtgov.active.collection.ActiveCollectionFactory;
import org.overlord.rtgov.active.collection.ActiveCollectionType;
import org.overlord.rtgov.active.collection.ActiveCollectionVisibility;
import org.overlord.rtgov.active.collection.predicate.Predicate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class ActiveCollectionSource {
    private static final Logger LOG = Logger.getLogger(ActiveCollectionSource.class.getName());
    private String _name = null;
    private ActiveCollectionType _type = ActiveCollectionType.List;
    private ActiveCollectionVisibility _visibility = ActiveCollectionVisibility.Public;
    private ActiveCollectionFactory _factory = null;
    private boolean _lazy = false;
    private long _itemExpiration = 0L;
    private int _maxItems = 0;
    private int _highWaterMark = 0;
    private List<DerivedDefinition> _derived = new ArrayList<DerivedDefinition>();
    private ActiveCollection _activeCollection = null;
    private List<ActiveCollection> _derivedActiveCollections = new ArrayList<ActiveCollection>();
    private List<AbstractActiveChangeListener> _listeners = new ArrayList<AbstractActiveChangeListener>();
    private String _maintenanceScript = null;
    private Serializable _maintenanceScriptExpression = null;
    private String _scheduledScript = null;
    private Serializable _scheduledScriptExpression = null;
    private long _scheduledInterval = 0L;
    private Timer _scheduledTimer = null;
    private Map<String, Object> _variables = new HashMap<String, Object>();
    private Map<String, Object> _properties = new HashMap<String, Object>();
    private long _aggregationDuration = 0L;
    private String _groupBy = null;
    private Serializable _groupByExpression = null;
    private String _aggregationScript = null;
    private Serializable _aggregationScriptCompiled = null;
    private Map<Object, List<Object>> _groupedEvents = new HashMap<Object, List<Object>>();
    private Aggregator _aggregator = null;
    private boolean _preinitialized = false;
    private ActiveCollectionContext _context = null;

    public ActiveCollectionSource() {
    }

    public ActiveCollectionSource(ActiveCollectionSource source) {
        this._name = source._name;
        this._type = source._type;
        this._visibility = source._visibility;
        this._factory = source._factory;
        this._lazy = source._lazy;
        this._itemExpiration = source._itemExpiration;
        this._maxItems = source._maxItems;
        this._highWaterMark = source._highWaterMark;
        this._activeCollection = source._activeCollection;
        this._listeners.addAll(source._listeners);
        this._maintenanceScript = source._maintenanceScript;
        this._maintenanceScriptExpression = source._maintenanceScriptExpression;
        this._scheduledScript = source._scheduledScript;
        this._scheduledScriptExpression = source._scheduledScriptExpression;
        this._scheduledInterval = source._scheduledInterval;
        this._scheduledTimer = source._scheduledTimer;
        this._variables = new HashMap<String, Object>(source._variables);
        this._properties = new HashMap<String, Object>(source._properties);
        this._aggregationDuration = source._aggregationDuration;
        this._groupBy = source._groupBy;
        this._groupByExpression = source._groupByExpression;
        this._aggregationScript = source._aggregationScript;
        this._aggregationScriptCompiled = source._aggregationScriptCompiled;
        this._groupedEvents = new HashMap<Object, List<Object>>(source._groupedEvents);
        this._aggregator = source._aggregator;
        this._preinitialized = source._preinitialized;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public ActiveCollectionType getType() {
        return this._type;
    }

    public void setType(ActiveCollectionType type) {
        this._type = type;
    }

    public ActiveCollectionVisibility getVisibility() {
        return this._visibility;
    }

    public void setVisibility(ActiveCollectionVisibility visibility) {
        this._visibility = visibility;
    }

    public ActiveCollectionFactory getFactory() {
        return this._factory;
    }

    public void setFactory(ActiveCollectionFactory factory) {
        this._factory = factory;
    }

    public boolean getLazy() {
        return this._lazy;
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    public long getItemExpiration() {
        return this._itemExpiration;
    }

    public void setItemExpiration(long expire) {
        this._itemExpiration = expire;
    }

    public int getMaxItems() {
        return this._maxItems;
    }

    public void setMaxItems(int max) {
        this._maxItems = max;
    }

    public int getHighWaterMark() {
        return this._highWaterMark;
    }

    public void setHighWaterMark(int highWaterMark) {
        this._highWaterMark = highWaterMark;
    }

    public List<DerivedDefinition> getDerived() {
        return this._derived;
    }

    public void setDerived(List<DerivedDefinition> derived) {
        this._derived = derived;
    }

    public boolean hasActiveCollection() {
        return this._activeCollection != null;
    }

    @JsonIgnore
    public synchronized ActiveCollection getActiveCollection() {
        if (this._activeCollection == null) {
            ActiveCollectionFactory factory = this._factory == null ? ActiveCollectionFactory.DEFAULT_FACTORY : this._factory;
            this._activeCollection = factory.createActiveCollection(this);
            if (this._activeCollection != null && this._listeners.size() > 0) {
                for (AbstractActiveChangeListener l : this._listeners) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("Register active collection '" + this.getName() + "' with listener from source: " + l);
                    }
                    this._activeCollection.addActiveChangeListener(l);
                }
            }
        }
        return this._activeCollection;
    }

    public void setActiveCollection(ActiveCollection ac) {
        this._activeCollection = ac;
    }

    @JsonIgnore
    public synchronized List<ActiveCollection> getDerivedActiveCollections() {
        if (this._activeCollection != null && this._derived.size() > 0 && this._derivedActiveCollections.size() == 0) {
            for (DerivedDefinition dd : this.getDerived()) {
                ActiveCollection derived = this._activeCollection.derive(dd.getName(), this._context, dd.getPredicate(), dd.getProperties());
                this._derivedActiveCollections.add(derived);
            }
        }
        return this._derivedActiveCollections;
    }

    public List<AbstractActiveChangeListener> getActiveChangeListeners() {
        return this._listeners;
    }

    public void setActiveChangeListeners(List<AbstractActiveChangeListener> listeners) {
        this._listeners = listeners;
    }

    public void setMaintenanceScript(String script) {
        this._maintenanceScript = script;
    }

    public String getMaintenanceScript() {
        return this._maintenanceScript;
    }

    public void setScheduledScript(String script) {
        this._scheduledScript = script;
    }

    public String getScheduledScript() {
        return this._scheduledScript;
    }

    public void setScheduledInterval(long interval) {
        this._scheduledInterval = interval;
    }

    public long getScheduledInterval() {
        return this._scheduledInterval;
    }

    protected Map<String, Object> getVariables() {
        return this._variables;
    }

    public Map<String, Object> getProperties() {
        return this._properties;
    }

    public void setProperties(Map<String, Object> props) {
        this._properties = props;
    }

    public void setAggregationDuration(long duration) {
        this._aggregationDuration = duration;
    }

    public long getAggregationDuration() {
        return this._aggregationDuration;
    }

    public void setGroupBy(String expr) {
        this._groupBy = expr;
    }

    public String getGroupBy() {
        return this._groupBy;
    }

    public void setAggregationScript(String script) {
        this._aggregationScript = script;
    }

    public String getAggregationScript() {
        return this._aggregationScript;
    }

    protected void preInit() throws Exception {
        if (!this._preinitialized) {
            byte[] b;
            InputStream is;
            this._preinitialized = true;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Pre-Initializing script=" + this._aggregationScript + " compiled=" + this._aggregationScriptCompiled);
            }
            if (this._aggregationScript != null && this._aggregationScriptCompiled == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._aggregationScript);
                if (is == null) {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-1"), this._aggregationScript));
                } else {
                    b = new byte[is.available()];
                    is.read(b);
                    is.close();
                    this._aggregationScriptCompiled = MVEL.compileExpression((String)new String(b));
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Pre-Initializing maintenance script=" + this._maintenanceScript + " compiled=" + this._maintenanceScriptExpression);
            }
            if (this._maintenanceScript != null && this._maintenanceScriptExpression == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._maintenanceScript);
                if (is == null) {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-1"), this._maintenanceScript));
                } else {
                    b = new byte[is.available()];
                    is.read(b);
                    is.close();
                    this._maintenanceScriptExpression = MVEL.compileExpression((String)new String(b));
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Pre-Initializing scheduled script=" + this._scheduledScript + " compiled=" + this._scheduledScriptExpression);
            }
            if (this._scheduledScript != null && this._scheduledScriptExpression == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._scheduledScript);
                if (is == null) {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-1"), this._scheduledScript));
                } else {
                    b = new byte[is.available()];
                    is.read(b);
                    is.close();
                    this._scheduledScriptExpression = MVEL.compileExpression((String)new String(b));
                }
            }
            if (this._listeners.size() > 0) {
                for (AbstractActiveChangeListener l : this._listeners) {
                    l.preInit();
                }
            }
        }
    }

    public void init(ActiveCollectionContext context) throws Exception {
        this._context = context;
        this.preInit();
        if (this._listeners.size() > 0) {
            for (AbstractActiveChangeListener l : this._listeners) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Initialize active collection '" + this.getName() + "' with listener from source: " + l);
                }
                l.init();
                if (this._activeCollection == null) continue;
                this._activeCollection.addActiveChangeListener(l);
            }
        }
        if (this._groupBy != null) {
            this._groupByExpression = MVEL.compileExpression((String)this._groupBy);
            if (this._aggregationDuration > 0L) {
                this._aggregator = new Aggregator();
            }
        }
        if (this._scheduledScriptExpression != null && this._scheduledInterval > 0L) {
            this._scheduledTimer = new Timer();
            this._scheduledTimer.scheduleAtFixedRate(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    vars.put("acs", ActiveCollectionSource.this);
                    vars.put("variables", ActiveCollectionSource.this._variables);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Call scheduled script on '" + ActiveCollectionSource.this.getName() + "' with variables: " + ActiveCollectionSource.this._variables);
                    }
                    ActiveCollectionSource activeCollectionSource = ActiveCollectionSource.this;
                    synchronized (activeCollectionSource) {
                        MVEL.executeExpression((Object)ActiveCollectionSource.this._scheduledScriptExpression, vars);
                    }
                }
            }, 0L, this._scheduledInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintainEntry(Object key, Object value) {
        if (this._maintenanceScriptExpression != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("acs", this);
            vars.put("key", key);
            vars.put("value", value);
            vars.put("variables", this._variables);
            ActiveCollectionSource activeCollectionSource = this;
            synchronized (activeCollectionSource) {
                MVEL.executeExpression((Object)this._maintenanceScriptExpression, vars);
            }
        } else {
            this.insert(key, value);
        }
    }

    public void insert(Object key, Object value) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("insert key=" + key + " value=" + value + " ac=" + this.getActiveCollection());
        }
        this.getActiveCollection().doInsert(key, value);
    }

    public void update(Object key, Object value) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("update key=" + key + " value=" + value + " ac=" + this.getActiveCollection());
        }
        this.getActiveCollection().doUpdate(key, value);
    }

    public void remove(Object key, Object value) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("remove key=" + key + " value=" + value + " ac=" + this.getActiveCollection());
        }
        this.getActiveCollection().doRemove(key, value);
    }

    @JsonIgnore
    protected Map<Object, List<Object>> getGroupedEvents() {
        return this._groupedEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void aggregateEvent(Serializable event) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("aggregateEvent event=" + event);
        }
        Map<Object, List<Object>> map = this._groupedEvents;
        synchronized (map) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Aggregating event: " + event);
            }
            Object key = MVEL.executeExpression((Object)this._groupByExpression, (Object)event);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Derived key '" + key + "' for event: " + event);
            }
            if (key == null) {
                LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-4"), this._groupBy, event));
            } else {
                List<Object> list = this._groupedEvents.get(key);
                if (list == null) {
                    list = new ArrayList<Object>();
                    this._groupedEvents.put(key, list);
                }
                list.add(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishAggregateEvents() {
        HashMap<Object, List<Object>> source = null;
        Map<Object, List<Object>> map = this._groupedEvents;
        synchronized (map) {
            if (this._groupedEvents.size() > 0) {
                source = new HashMap<Object, List<Object>>(this._groupedEvents);
                this._groupedEvents.clear();
            }
        }
        if (source != null) {
            if (this._aggregationScriptCompiled != null) {
                HashMap<String, List> vars = new HashMap<String, List>();
                for (List list : source.values()) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("publishAggregateEvents list=" + list);
                    }
                    vars.clear();
                    vars.put("events", list);
                    Object result = MVEL.executeExpression((Object)this._aggregationScriptCompiled, vars);
                    if (result == null) {
                        LOG.severe(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-5"));
                        if (!LOG.isLoggable(Level.FINEST)) continue;
                        LOG.finest("Script=" + this._aggregationScript);
                        LOG.finest("List of Events=" + list);
                        continue;
                    }
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("publishAggregateEvents result=" + result);
                    }
                    this.maintainEntry(null, result);
                }
            } else {
                LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-6"), source));
            }
        }
    }

    public void close() throws Exception {
        if (this._listeners.size() > 0 && this._activeCollection != null) {
            for (AbstractActiveChangeListener l : this._listeners) {
                this._activeCollection.removeActiveChangeListener(l);
                l.close();
            }
        }
        if (this._aggregator != null) {
            this._aggregator.cancel();
        }
        if (this._scheduledTimer != null) {
            this._scheduledTimer.cancel();
        }
    }

    public class Aggregator
    extends TimerTask {
        private Timer _timer = new Timer();

        public Aggregator() {
            this._timer.scheduleAtFixedRate((TimerTask)this, ActiveCollectionSource.this._aggregationDuration, ActiveCollectionSource.this._aggregationDuration);
        }

        @Override
        public void run() {
            ActiveCollectionSource.this.publishAggregateEvents();
        }
    }

    public static class DerivedDefinition {
        private String _name = null;
        private Predicate _predicate = null;
        private Map<String, Object> _properties = new HashMap<String, Object>();

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setPredicate(Predicate predicate) {
            this._predicate = predicate;
        }

        public Predicate getPredicate() {
            return this._predicate;
        }

        public Map<String, Object> getProperties() {
            return this._properties;
        }

        public void setProperties(Map<String, Object> props) {
            this._properties = props;
        }
    }
}

