/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.call.trace;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.ActivityUnit;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.activity.model.app.LogMessage;
import org.overlord.rtgov.activity.model.soa.RPCActivityType;
import org.overlord.rtgov.activity.model.soa.RequestReceived;
import org.overlord.rtgov.activity.model.soa.RequestSent;
import org.overlord.rtgov.activity.model.soa.ResponseReceived;
import org.overlord.rtgov.activity.model.soa.ResponseSent;
import org.overlord.rtgov.activity.server.ActivityServer;
import org.overlord.rtgov.call.trace.descriptors.TaskDescriptorFactory;
import org.overlord.rtgov.call.trace.model.Call;
import org.overlord.rtgov.call.trace.model.CallTrace;
import org.overlord.rtgov.call.trace.model.Task;
import org.overlord.rtgov.call.trace.model.TraceNode;
import org.overlord.rtgov.call.trace.util.CallTraceUtil;

public class CallTraceProcessor {
    private static final Logger LOG = Logger.getLogger(CallTraceProcessor.class.getName());
    private ActivityServer _activityServer = null;

    public void setActivityServer(ActivityServer as) {
        this._activityServer = as;
    }

    public ActivityServer getActivityServer() {
        return this._activityServer;
    }

    public CallTrace createCallTrace(String correlation) throws Exception {
        CTState state = new CTState();
        this.loadActivityUnits(state, correlation);
        return CallTraceProcessor.processAUs(state);
    }

    protected void loadActivityUnits(CTState state, String correlation) {
        if (!state.isCorrelationInitialized(correlation)) {
            try {
                List ats = this._activityServer.getActivityTypes(correlation);
                ArrayList<ActivityUnit> aus = new ArrayList<ActivityUnit>();
                for (ActivityType at : ats) {
                    if (state.isActivityUnitLoaded(at.getUnitId())) continue;
                    ActivityUnit au = this._activityServer.getActivityUnit(at.getUnitId());
                    aus.add(au);
                    state.add(au);
                }
                state.initialized(correlation);
                for (ActivityUnit au : aus) {
                    for (ActivityType at : au.getActivityTypes()) {
                        for (Context c : at.getContext()) {
                            this.loadActivityUnits(state, c.getValue());
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("call-trace.Messages").getString("CALL-TRACE-1"), correlation), e);
            }
        }
    }

    protected static CallTrace processAUs(CTState state) {
        CallTrace ret = new CallTrace();
        List<ActivityUnit> topLevel = CallTraceProcessor.getTopLevelAUs(state);
        state.getTasksStack().push(ret.getTasks());
        for (ActivityUnit au : topLevel) {
            CallTraceProcessor.processAU(state, au, topLevel);
        }
        state.finalizeScope();
        return ret;
    }

    protected static void processAU(CTState state, ActivityUnit startau, List<ActivityUnit> topLevel) {
        List<ActivityUnit> aus;
        int aupos;
        ActivityType cur = null;
        Call call = state.getCallStack().size() > 0 ? state.getCallStack().peek() : null;
        List<TraceNode> tasks = state.getTasksStack().size() > 0 ? state.getTasksStack().peek() : null;
        ActivityType prev = null;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Start Process Initial AU=" + startau);
        }
        if ((aupos = (aus = state.getActivityUnits()).indexOf(startau)) == -1) {
            LOG.severe("Failed to find activity unit in list=" + startau);
            return;
        }
        boolean f_end = false;
        boolean f_scopeFinalized = false;
        block0: for (int i = aupos; !f_end && i < aus.size(); ++i) {
            ActivityUnit au = aus.get(i);
            if (i != aupos && topLevel.contains(au)) continue;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Process AU=" + aus.get(i));
            }
            ActivityUnitCursor cursor = state.getCursor(au);
            while ((cur = cursor.next()) != null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Processing cur=" + cur);
                }
                if (CallTraceProcessor.shouldPostpone(state, au, topLevel, cur)) continue block0;
                if (cur instanceof RPCActivityType) {
                    if (cur instanceof RequestSent || cur instanceof RequestReceived && call == null) {
                        call = CallTraceProcessor.createCall((RPCActivityType)cur);
                        if (tasks != null) {
                            tasks.add(call);
                        } else if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Attempt to add call node to 'null' tasks list");
                        }
                        tasks = call.getTasks();
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Pushing call=" + call);
                            LOG.finest("Pushing tasks=" + tasks);
                        }
                        state.getCallStack().push(call);
                        state.getTasksStack().push(tasks);
                        state.getTriggerActivities().put(call, (RPCActivityType)cur);
                    }
                    if (cur instanceof RequestSent) {
                        CallTraceProcessor.instrumentCall(call, au, (RPCActivityType)((RequestSent)cur));
                        RPCActivityType rr = state.getSOAActivity(RequestReceived.class, ((RequestSent)cur).getServiceType(), ((RequestSent)cur).getOperation());
                        if (rr != null) {
                            call.setRequestLatency(rr.getTimestamp() - cur.getTimestamp());
                            ActivityUnit subAU = state.getActivityUnit(rr.getUnitId());
                            if (subAU != null) {
                                CallTraceProcessor.processAU(state, subAU, topLevel);
                                call = state.getCallStack().size() > 0 ? state.getCallStack().peek() : null;
                                tasks = state.getTasksStack().size() > 0 ? state.getTasksStack().peek() : null;
                            }
                        }
                    } else if (cur instanceof RequestReceived) {
                        CallTraceProcessor.instrumentCall(call, au, (RPCActivityType)((RequestReceived)cur));
                        call.setRequest(((RequestReceived)cur).getContent());
                    } else if (cur instanceof ResponseSent) {
                        CallTraceProcessor.initializeResponseSent(state, (ResponseSent)cur, call);
                        state.finalizeScope();
                        f_scopeFinalized = true;
                        call = state.getCallStack().size() > 0 ? state.getCallStack().peek() : null;
                        List<TraceNode> list = tasks = state.getTasksStack().size() > 0 ? state.getTasksStack().peek() : null;
                        if (state.getCallStack().size() > 0) {
                            if (LOG.isLoggable(Level.FINEST)) {
                                LOG.finest("Break on response sent");
                            }
                            f_end = true;
                            continue block0;
                        }
                    } else if (cur instanceof ResponseReceived) {
                        CallTraceProcessor.initializeResponseReceived(state, (ResponseReceived)cur);
                        f_end = true;
                    }
                } else {
                    Task task = CallTraceProcessor.createTask(cur);
                    tasks.add(task);
                    if (prev != null) {
                        task.setDuration(cur.getTimestamp() - prev.getTimestamp());
                    }
                }
                prev = cur;
            }
        }
        if (!f_scopeFinalized) {
            state.finalizeScope();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Finished Process Initial AU=" + startau);
        }
    }

    protected static void initializeResponseSent(CTState state, ResponseSent rs, Call call) {
        if (call == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("No call, so unable to initialize ResponseSent '" + rs + "' for state=" + state);
            }
            return;
        }
        call.setResponse(rs.getContent());
        call.getProperties().putAll(rs.getProperties());
        RPCActivityType rr = state.getSOAActivity(ResponseReceived.class, rs.getServiceType(), rs.getOperation());
        if (rr != null) {
            call.setResponseLatency(rr.getTimestamp() - rs.getTimestamp());
        }
        if (state.getTriggerActivities().get(call) instanceof RequestReceived) {
            call.setDuration(rs.getTimestamp() - state.getTriggerActivities().get(call).getTimestamp());
        }
        if (rs.getFault() != null && rs.getFault().trim().length() > 0) {
            call.setFault(rs.getFault());
            call.setStatus(TraceNode.Status.Fail);
        }
    }

    protected static void initializeResponseReceived(CTState state, ResponseReceived rr) {
        for (int j = state.getCompletedCallStack().size() - 1; j >= 0; --j) {
            RequestSent rs;
            Call c = (Call)state.getCompletedCallStack().get(j);
            if (!(state.getTriggerActivities().get(c) instanceof RequestSent) || !(rs = (RequestSent)state.getTriggerActivities().get(c)).getOperation().equals(rr.getOperation()) || !rs.getServiceType().equals(rr.getServiceType())) continue;
            c.setDuration(rr.getTimestamp() - rs.getTimestamp());
            break;
        }
    }

    protected static boolean shouldPostpone(CTState state, ActivityUnit au, List<ActivityUnit> topLevel, ActivityType cur) {
        Call call;
        boolean ret = false;
        Call call2 = call = state.getCallStack().size() > 0 ? state.getCallStack().peek() : null;
        if (cur instanceof RequestReceived && call == null && !topLevel.contains(au)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Postpone processing unit due to receiving request before it has been sent");
            }
            ret = true;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Should postpone processing of unit=" + au + " cur=" + cur + "? ret=" + ret);
        }
        return ret;
    }

    protected static Call createCall(RPCActivityType at) {
        Call call = new Call();
        call.setComponent(at.getServiceType());
        call.setOperation(at.getOperation());
        call.setPrincipal(at.getPrincipal());
        call.getProperties().putAll(at.getProperties());
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Created call=" + call);
        }
        return call;
    }

    protected static void instrumentCall(Call call, ActivityUnit au, RPCActivityType at) {
        if (au != null && au.getOrigin() != null) {
            if (at instanceof RequestSent) {
                call.getProperties().put("client-host", au.getOrigin().getHost());
                call.getProperties().put("client-node", au.getOrigin().getNode());
            } else if (at instanceof RequestReceived) {
                call.getProperties().put("server-host", au.getOrigin().getHost());
                call.getProperties().put("server-node", au.getOrigin().getNode());
            }
        }
    }

    protected static Task createTask(ActivityType at) {
        Task ret = new Task();
        ret.getProperties().putAll(at.getProperties());
        try {
            BeanInfo bi = Introspector.getBeanInfo(at.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!CallTraceUtil.shouldIncludeProperty(pd)) continue;
                try {
                    Object value = pd.getReadMethod().invoke((Object)at, new Object[0]);
                    if (value == null) continue;
                    ret.getProperties().put(pd.getDisplayName(), value.toString());
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to get property '" + pd.getDisplayName() + "'", ex);
                }
            }
        }
        catch (IntrospectionException e) {
            LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("call-trace.Messages").getString("CALL-TRACE-2"), at.getClass().getName()), e);
        }
        ret.setDescription(TaskDescriptorFactory.getTaskDescriptor(at).getDescription(at));
        ret.setStatus(CallTraceProcessor.getStatus(at));
        return ret;
    }

    protected static TraceNode.Status getStatus(ActivityType at) {
        TraceNode.Status ret = TraceNode.Status.Success;
        if (at instanceof LogMessage) {
            LogMessage lm = (LogMessage)at;
            if (lm.getLevel() == LogMessage.Level.Warning) {
                ret = TraceNode.Status.Warning;
            } else if (lm.getLevel() == LogMessage.Level.Error) {
                ret = TraceNode.Status.Fail;
            }
        }
        return ret;
    }

    protected static List<ActivityUnit> getTopLevelAUs(CTState state) {
        ArrayList<ActivityUnit> ret = new ArrayList<ActivityUnit>();
        for (ActivityUnit au : state.getActivityUnits()) {
            for (ActivityType at : au.getActivityTypes()) {
                if (!(at instanceof RequestReceived) || state.getSOAActivity(RequestSent.class, ((RequestReceived)at).getServiceType(), ((RequestReceived)at).getOperation()) != null) continue;
                ret.add(au);
            }
        }
        return ret;
    }

    public static class CTState {
        private List<String> _correlations = new ArrayList<String>();
        private List<ActivityUnit> _units = new ArrayList<ActivityUnit>();
        private Map<String, ActivityUnit> _unitIndex = new HashMap<String, ActivityUnit>();
        private Map<String, ActivityUnitCursor> _cursors = new HashMap<String, ActivityUnitCursor>();
        private Stack<Call> _callStack = new Stack();
        private Stack<Call> _completedCallStack = new Stack();
        private Stack<List<TraceNode>> _tasksStack = new Stack();
        private Map<Call, RPCActivityType> _triggerActivity = new HashMap<Call, RPCActivityType>();

        public boolean isCorrelationInitialized(String correlation) {
            return this._correlations.contains(correlation);
        }

        public void initialized(String correlation) {
            if (!this._correlations.contains(correlation)) {
                this._correlations.add(correlation);
            }
        }

        public boolean isActivityUnitLoaded(String id) {
            return this._unitIndex.containsKey(id);
        }

        public void add(ActivityUnit au) {
            this._units.add(au);
            this._unitIndex.put(au.getId(), au);
            this._cursors.put(au.getId(), new ActivityUnitCursor(au));
        }

        public List<ActivityUnit> getActivityUnits() {
            return this._units;
        }

        public Map<Call, RPCActivityType> getTriggerActivities() {
            return this._triggerActivity;
        }

        public ActivityUnit getActivityUnit(String id) {
            return this._unitIndex.get(id);
        }

        public ActivityUnitCursor getCursor(ActivityUnit au) {
            return this._cursors.get(au.getId());
        }

        public void sortActivityUnitsByTime() {
            Collections.sort(this._units, new Comparator<ActivityUnit>(){

                @Override
                public int compare(ActivityUnit o1, ActivityUnit o2) {
                    return (int)(((ActivityType)o1.getActivityTypes().get(0)).getTimestamp() - ((ActivityType)o2.getActivityTypes().get(0)).getTimestamp());
                }
            });
        }

        public Stack<Call> getCallStack() {
            return this._callStack;
        }

        public Stack<Call> getCompletedCallStack() {
            return this._completedCallStack;
        }

        public Stack<List<TraceNode>> getTasksStack() {
            return this._tasksStack;
        }

        public void finalizeScope() {
            Call call;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Finalize scope");
            }
            if (this.getTasksStack().isEmpty()) {
                return;
            }
            List<TraceNode> tasks = this.getTasksStack().peek();
            long duration = 0L;
            TraceNode.Status status = TraceNode.Status.Success;
            for (TraceNode task : tasks) {
                duration += task.getDuration();
                if (task.getStatus().ordinal() <= status.ordinal()) continue;
                status = task.getStatus();
            }
            if (duration > 0L) {
                for (TraceNode task : tasks) {
                    task.setPercentage((int)((double)task.getDuration() / (double)duration * 100.0));
                }
            }
            Call call2 = call = this.getCallStack().size() > 0 ? this.getCallStack().pop() : null;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Popping call=" + call);
                LOG.finest("Popping tasks=" + this.getTasksStack().peek());
            }
            if (call != null) {
                this._completedCallStack.push(call);
                if (status != TraceNode.Status.Success && call.getStatus().ordinal() < TraceNode.Status.Warning.ordinal()) {
                    call.setStatus(TraceNode.Status.Warning);
                }
            }
            this.getTasksStack().pop();
        }

        protected RPCActivityType getSOAActivity(Class<?> cls, String serviceType, String operation) {
            for (ActivityUnit au : this._units) {
                ActivityUnitCursor cursor = this._cursors.get(au.getId());
                for (ActivityType at : cursor.getActivityTypes()) {
                    if (at.getClass() != cls || !((RPCActivityType)at).getServiceType().equals(serviceType) || !((RPCActivityType)at).getOperation().equals(operation)) continue;
                    return (RPCActivityType)at;
                }
            }
            return null;
        }
    }

    public static class ActivityUnitCursor {
        private ActivityUnit _unit = null;
        private int _index = 0;

        public ActivityUnitCursor(ActivityUnit unit) {
            this._unit = unit;
        }

        public List<ActivityType> getActivityTypes() {
            ArrayList<ActivityType> ret = new ArrayList<ActivityType>();
            for (int i = this._index; i < this._unit.getActivityTypes().size(); ++i) {
                ret.add((ActivityType)this._unit.getActivityTypes().get(i));
            }
            return ret;
        }

        public ActivityType peek() {
            if (this._index < this._unit.getActivityTypes().size()) {
                return (ActivityType)this._unit.getActivityTypes().get(this._index);
            }
            return null;
        }

        public ActivityType next() {
            if (this._index < this._unit.getActivityTypes().size()) {
                return (ActivityType)this._unit.getActivityTypes().get(this._index++);
            }
            return null;
        }
    }
}

