/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.call.trace;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.UserTransaction;
import org.overlord.rtgov.call.trace.Transactional;

@Transactional
@Interceptor
public class TransactionalInterceptor {
    private static final Logger LOG = Logger.getLogger(TransactionalInterceptor.class.getName());
    @Resource
    private UserTransaction _tx;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AroundInvoke
    public Object manageTransaction(InvocationContext context) throws Exception {
        Object result = null;
        if (this._tx.getStatus() == 6) {
            this._tx.begin();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Starting transaction: context=" + context + " op=" + context.getMethod());
            }
            try {
                result = context.proceed();
                this._tx.commit();
                if (!LOG.isLoggable(Level.FINEST)) return result;
                LOG.finest("Committing transaction: context=" + context);
                return result;
            }
            catch (Exception e) {
                this._tx.rollback();
                if (!LOG.isLoggable(Level.FINEST)) throw e;
                LOG.finest("Rolling back transaction: context=" + context + " exception=" + e);
                throw e;
            }
        } else {
            if (!LOG.isLoggable(Level.FINEST)) return context.proceed();
            LOG.finest("Transaction already active: context=" + context + " op=" + context.getMethod());
            return context.proceed();
        }
    }
}

