/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.service.dependency.svg;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mvel2.MVEL;
import org.overlord.rtgov.analytics.service.InvocationMetric;
import org.overlord.rtgov.service.dependency.svg.ColorSelector;

public class MVELColorSelector
implements ColorSelector {
    private static final Logger LOG = Logger.getLogger(MVELColorSelector.class.getName());
    private String _scriptLocation = null;
    private Serializable _scriptExpression = null;

    public void setScriptLocation(String location) {
        this._scriptLocation = location;
    }

    public void init() throws Exception {
        if (this._scriptLocation != null && this._scriptExpression == null) {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._scriptLocation);
            if (is == null) {
                throw new Exception("Unable to locate '" + this._scriptLocation + "'");
            }
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            this._scriptExpression = MVEL.compileExpression((String)new String(b));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Initialized description script=" + this._scriptLocation + " compiled=" + this._scriptExpression);
            }
        }
    }

    @Override
    public String getColor(Object component, InvocationMetric metric) {
        String ret = null;
        if (this._scriptExpression != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("component", component);
            vars.put("metric", metric);
            ret = (String)MVEL.executeExpression((Object)this._scriptExpression, vars);
        }
        return ret;
    }
}

