/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.activity.client.jee;

import java.lang.management.ManagementFactory;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.overlord.rtgov.activity.collector.AbstractActivityCollector;
import org.overlord.rtgov.activity.collector.ActivityCollector;

@Singleton
public class JEEActivityCollector
extends AbstractActivityCollector
implements ActivityCollector {
    private static final Logger LOG = Logger.getLogger(JEEActivityCollector.class.getName());
    private static final String OBJECT_NAME_DOMAIN = "overlord.rtgov.collector";
    private static final String OBJECT_NAME_COLLECTOR = "overlord.rtgov.collector:name=ActivityCollector";

    @PostConstruct
    public void init() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Register the ActivityCollector MBean[overlord.rtgov.collector:name=ActivityCollector]: " + (Object)((Object)this));
            }
            ObjectName objname1 = new ObjectName(OBJECT_NAME_COLLECTOR);
            mbs.registerMBean((Object)this, objname1);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity-client-jee.Messages").getString("ACTIVITY-CLIENT-JEE-1"), e);
        }
    }

    @PreDestroy
    public void close() throws Exception {
        block3: {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Unregister the ActivityCollector MBean[overlord.rtgov.collector:name=ActivityCollector]: " + (Object)((Object)this));
                }
                ObjectName objname1 = new ObjectName(OBJECT_NAME_COLLECTOR);
                mbs.unregisterMBean(objname1);
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINER)) break block3;
                LOG.log(Level.FINER, PropertyResourceBundle.getBundle("activity-client-jee.Messages").getString("ACTIVITY-CLIENT-JEE-2"), t);
            }
        }
    }
}

