/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.activity.validator.loader.jee;

import java.io.InputStream;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import org.overlord.rtgov.activity.util.ActivityValidatorUtil;
import org.overlord.rtgov.activity.validator.ActivityValidator;
import org.overlord.rtgov.activity.validator.ActivityValidatorManager;
import org.overlord.rtgov.activity.validator.ActivityValidatorManagerAccessor;

@ApplicationScoped
@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class JEEAVLoader {
    private static final Logger LOG = Logger.getLogger(JEEAVLoader.class.getName());
    private static final String AV_JSON = "av.json";
    private ActivityValidatorManager _avManager = null;
    private List<ActivityValidator> _activityValidators = null;

    @PostConstruct
    public void init() {
        this._avManager = ActivityValidatorManagerAccessor.getActivityValidatorManager();
        if (this._avManager == null) {
            LOG.severe(PropertyResourceBundle.getBundle("av-loader-jee.Messages").getString("AV-LOADER-JEE-5"));
        }
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(AV_JSON);
            if (is == null) {
                LOG.severe(PropertyResourceBundle.getBundle("av-loader-jee.Messages").getString("AV-LOADER-JEE-1"));
            } else {
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                this._activityValidators = ActivityValidatorUtil.deserializeActivityValidatorList((byte[])b);
                if (this._activityValidators == null) {
                    LOG.severe(PropertyResourceBundle.getBundle("av-loader-jee.Messages").getString("AV-LOADER-JEE-2"));
                } else {
                    for (ActivityValidator ai : this._activityValidators) {
                        ai.init();
                        this._avManager.register(ai);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("av-loader-jee.Messages").getString("AV-LOADER-JEE-3"), e);
        }
    }

    @PreDestroy
    public void close() {
        block4: {
            if (this._avManager != null && this._activityValidators != null) {
                try {
                    for (ActivityValidator ai : this._activityValidators) {
                        this._avManager.unregister(ai);
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.FINER)) break block4;
                    LOG.log(Level.FINER, PropertyResourceBundle.getBundle("av-loader-jee.Messages").getString("AV-LOADER-JEE-4"), t);
                }
            }
        }
    }
}

