/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.activity.validator.loader.jee;

import java.io.InputStream;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import org.overlord.commons.services.ServiceListener;
import org.overlord.commons.services.ServiceRegistryUtil;
import org.overlord.rtgov.activity.util.ActivityValidatorUtil;
import org.overlord.rtgov.activity.validator.ActivityValidator;
import org.overlord.rtgov.activity.validator.ActivityValidatorManager;

@ApplicationScoped
@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class JEEAVLoader {
    private static final Logger LOG = Logger.getLogger(JEEAVLoader.class.getName());
    private static final String AV_JSON = "av.json";
    private List<ActivityValidator> _activityValidators = null;
    private ServiceListener<ActivityValidatorManager> _listener;

    @PostConstruct
    public void init() {
        this._listener = new ServiceListener<ActivityValidatorManager>(){

            public void registered(ActivityValidatorManager service) {
                JEEAVLoader.this.registerActivityValidator(service);
            }

            public void unregistered(ActivityValidatorManager service) {
                JEEAVLoader.this.unregisterActivityValidator(service);
            }
        };
        ServiceRegistryUtil.addServiceListener(ActivityValidatorManager.class, this._listener);
    }

    protected void registerActivityValidator(ActivityValidatorManager avManager) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Register ActivityValidatorManager");
        }
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(AV_JSON);
            if (is == null) {
                LOG.severe(PropertyResourceBundle.getBundle("av-loader-jee.Messages").getString("AV-LOADER-JEE-1"));
            } else {
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                this._activityValidators = ActivityValidatorUtil.deserializeActivityValidatorList((byte[])b);
                if (this._activityValidators == null) {
                    LOG.severe(PropertyResourceBundle.getBundle("av-loader-jee.Messages").getString("AV-LOADER-JEE-2"));
                } else {
                    for (ActivityValidator ai : this._activityValidators) {
                        ai.init();
                        avManager.register(ai);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("av-loader-jee.Messages").getString("AV-LOADER-JEE-3"), e);
        }
    }

    protected void unregisterActivityValidator(ActivityValidatorManager avManager) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unregister ActivityValidatorManager");
        }
        if (avManager != null && this._activityValidators != null) {
            try {
                for (ActivityValidator ai : this._activityValidators) {
                    avManager.unregister(ai);
                }
                this._activityValidators = null;
            }
            catch (Exception e) {
                LOG.log(Level.FINER, PropertyResourceBundle.getBundle("av-loader-jee.Messages").getString("AV-LOADER-JEE-4"), e);
            }
        }
    }

    @PreDestroy
    public void close() {
        ActivityValidatorManager acManager;
        if (this._listener != null && (acManager = (ActivityValidatorManager)ServiceRegistryUtil.getSingleService(ActivityValidatorManager.class)) != null) {
            this.unregisterActivityValidator(acManager);
        }
        ServiceRegistryUtil.removeServiceListener(this._listener);
        this._listener = null;
    }
}

