/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.common.util;

import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import org.overlord.rtgov.common.util.RTGovPropertiesProvider;

public final class RTGovProperties {
    private static final Logger LOG = Logger.getLogger(RTGovProperties.class.getName());
    private static RTGovPropertiesProvider _provider = null;
    private static boolean _initialized = false;

    private RTGovProperties() {
    }

    public static void setPropertiesProvider(RTGovPropertiesProvider props) {
        _provider = props;
    }

    public static RTGovPropertiesProvider getPropertiesProvider() {
        if (_provider == null && !_initialized) {
            block5: {
                try {
                    BeanManager bm = (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
                    Set beans = bm.getBeans(RTGovPropertiesProvider.class, new Annotation[0]);
                    for (Bean b : beans) {
                        CreationalContext<Object> cc = new CreationalContext<Object>(){

                            public void push(Object arg0) {
                            }

                            public void release() {
                            }
                        };
                        _provider = (RTGovPropertiesProvider)b.create((CreationalContext)cc);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Found Runtime Governance Properties provider=" + _provider);
                        }
                        if (_provider == null) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.warning(PropertyResourceBundle.getBundle("rtgov-common.Messages").getString("RTGOV-COMMON-1"));
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.log(Level.FINE, "Failed to get runtime governance properties", e);
                }
            }
            _initialized = true;
        }
        return _provider;
    }

    public static String getProperty(String name) {
        String ret = null;
        if (RTGovProperties.getPropertiesProvider() != null) {
            ret = RTGovProperties.getPropertiesProvider().getProperty(name);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Runtime Governance property '" + name + "' = " + ret);
        }
        return ret;
    }

    public static Properties getProperties() {
        Properties ret = null;
        if (RTGovProperties.getPropertiesProvider() != null) {
            ret = RTGovProperties.getPropertiesProvider().getProperties();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Runtime Governance properties = " + ret);
        }
        return ret;
    }
}

