/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.common.util;

import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.overlord.commons.config.ConfigurationFactory;
import org.overlord.rtgov.common.util.RTGovPropertiesProvider;

public class DefaultRTGovPropertiesProvider
implements RTGovPropertiesProvider {
    private static final String OVERLORD_RTGOV_PROPERTIES = "overlord-rtgov.properties";
    private static final String RTGOV_CONFIG_FILE_NAME = "rtgov.config.file.name";
    private static final String RTGOV_CONFIG_FILE_REFRESH = "rtgov.config.file.refresh";
    private static Configuration _configuration;

    @Override
    public Properties getProperties() {
        if (_configuration == null) {
            String configFile = System.getProperty(RTGOV_CONFIG_FILE_NAME);
            String refreshDelayStr = System.getProperty(RTGOV_CONFIG_FILE_REFRESH);
            Long refreshDelay = 5000L;
            if (refreshDelayStr != null) {
                refreshDelay = new Long(refreshDelayStr);
            }
            _configuration = ConfigurationFactory.createConfig((String)configFile, (String)OVERLORD_RTGOV_PROPERTIES, (Long)refreshDelay, null, DefaultRTGovPropertiesProvider.class);
        }
        Properties properties = new Properties();
        Iterator keys = _configuration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = _configuration.getString(key);
            if (value == null) continue;
            properties.setProperty(key, value);
        }
        return properties;
    }

    @Override
    public String getProperty(String name) {
        Properties props = this.getProperties();
        if (props != null) {
            return props.getProperty(name);
        }
        return null;
    }
}

