/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.common.infinispan;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.overlord.rtgov.common.util.RTGovProperties;

public final class InfinispanManager {
    private static final String INFINISPAN_CONTAINER = "infinispan.container";
    private static final String INFINISPAN_CONFIG = "infinispan.config";
    private static Object _cacheContainer = null;
    private static final Logger LOG = Logger.getLogger(InfinispanManager.class.getName());

    private InfinispanManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized CacheContainer getCacheContainer(String container) {
        CacheContainer ret = null;
        boolean f_initDefault = false;
        String config = null;
        if (container == null && _cacheContainer == null) {
            container = RTGovProperties.getProperty((String)INFINISPAN_CONTAINER);
            config = RTGovProperties.getProperty((String)INFINISPAN_CONFIG);
            f_initDefault = true;
        }
        if (container != null) {
            try {
                InitialContext ctx = new InitialContext();
                ret = (CacheContainer)ctx.lookup(container);
                ret.start();
                if (f_initDefault) {
                    _cacheContainer = ret;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("rtgov-infinispan.Messages").getString("RTGOV-INFINISPAN-1"), container), e);
            }
        } else {
            if (_cacheContainer == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(DefaultCacheManager.class.getClassLoader());
                    _cacheContainer = config != null ? new DefaultCacheManager(config) : new DefaultCacheManager();
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("rtgov-infinispan.Messages").getString("RTGOV-INFINISPAN-2"), container), e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
            ret = (CacheContainer)_cacheContainer;
        }
        return ret;
    }
}

