/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.switchyard.camel;

import java.util.EventObject;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.management.event.AbstractExchangeEvent;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.soa.RPCActivityType;
import org.overlord.rtgov.activity.model.soa.RequestReceived;
import org.overlord.rtgov.activity.model.soa.RequestSent;
import org.overlord.rtgov.activity.model.soa.ResponseReceived;
import org.overlord.rtgov.activity.model.soa.ResponseSent;
import org.overlord.rtgov.switchyard.AbstractEventProcessor;
import org.switchyard.ExchangePhase;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.bus.camel.CamelCompositeContext;
import org.switchyard.bus.camel.CamelMessage;
import org.switchyard.extensions.wsdl.WSDLService;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.security.SecurityContext;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.NameCredential;
import org.switchyard.security.credential.PrincipalCredential;

public abstract class AbstractExchangeEventProcessor
extends AbstractEventProcessor {
    private static final Logger LOG = Logger.getLogger(AbstractExchangeEventProcessor.class.getName());

    public AbstractExchangeEventProcessor(Class<? extends EventObject> eventType) {
        super(eventType);
    }

    @Override
    public void handleEvent(EventObject event) {
        Exchange exch = ((AbstractExchangeEvent)event).getExchange();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("********* Exchange=" + exch);
        }
        CamelMessage mesg = (CamelMessage)exch.getIn();
        ExchangePhase phase = (ExchangePhase)exch.getProperty("org.switchyard.bus.camel.phase", ExchangePhase.class);
        if (phase == null) {
            LOG.severe("Could not obtain phase from exchange: " + exch);
            return;
        }
        if (mesg == null) {
            LOG.severe("Could not obtain message for phase (" + phase + ") and exchange: " + exch);
            return;
        }
        CamelCompositeContext context = new CamelCompositeContext(exch, (Message)mesg);
        Service provider = (Service)exch.getProperty("org.switchyard.bus.camel.provider", Service.class);
        ServiceReference consumer = (ServiceReference)exch.getProperty("org.switchyard.bus.camel.consumer", ServiceReference.class);
        SecurityContext securityContext = (SecurityContext)exch.getProperty("org.switchyard.bus.camel.securityContext", SecurityContext.class);
        BaseExchangeContract contract = (BaseExchangeContract)exch.getProperty("org.switchyard.bus.camel.contract", BaseExchangeContract.class);
        String messageId = null;
        String relatesTo = null;
        String contentType = null;
        Set props = context.getProperties(Scope.MESSAGE);
        for (Property p : props) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Switchyard property: name=" + p.getName() + " value=" + p.getValue());
            }
            if (p.getName().equals("org.switchyard.messageId")) {
                messageId = (String)p.getValue();
                continue;
            }
            if (p.getName().equals("org.switchyard.relatesTo")) {
                relatesTo = (String)p.getValue();
                continue;
            }
            if (!p.getName().equals("org.switchyard.contentType")) continue;
            contentType = ((QName)p.getValue()).toString();
        }
        QName serviceType = consumer.getName();
        String opName = contract.getConsumerOperation().getName();
        if (phase == ExchangePhase.IN) {
            String intf = this.getInterface(consumer, provider);
            if (consumer.getConsumerMetadata().isBinding()) {
                this.getActivityCollector().startScope();
            } else {
                RequestSent sent = new RequestSent();
                if (provider == null || !provider.getProviderMetadata().isBinding()) {
                    sent.setServiceType(serviceType.toString());
                }
                sent.setInterface(intf);
                sent.setOperation(opName);
                sent.setMessageId(messageId);
                this.record((org.switchyard.Message)mesg, contentType, (RPCActivityType)sent, securityContext, exch);
                if (intf == null) {
                    exch.setProperty("rtgov.request.sent", (Object)sent);
                }
            }
            if (provider == null || !provider.getProviderMetadata().isBinding()) {
                RequestReceived recvd = new RequestReceived();
                recvd.setServiceType(serviceType.toString());
                recvd.setInterface(intf);
                recvd.setOperation(opName);
                recvd.setMessageId(messageId);
                this.record((org.switchyard.Message)mesg, contentType, (RPCActivityType)recvd, securityContext, exch);
                if (intf == null) {
                    exch.setProperty("rtgov.request.received", (Object)recvd);
                }
            }
        } else if (phase == ExchangePhase.OUT) {
            if (contentType == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("No content type - possibly due to exception on handling the request");
                }
                return;
            }
            String intf = this.getInterface(consumer, provider);
            RequestReceived rr = (RequestReceived)exch.getProperty("rtgov.request.received");
            RequestSent rs = (RequestSent)exch.getProperty("rtgov.request.sent");
            if (intf != null) {
                if (rr != null) {
                    rr.setInterface(intf);
                }
                if (rs != null) {
                    rs.setInterface(intf);
                }
            }
            if (provider == null || !provider.getProviderMetadata().isBinding()) {
                ResponseSent sent = new ResponseSent();
                if (provider == null || !provider.getProviderMetadata().isBinding()) {
                    sent.setServiceType(serviceType.toString());
                }
                sent.setInterface(intf);
                sent.setOperation(opName);
                sent.setMessageId(messageId);
                sent.setReplyToId(relatesTo);
                this.record((org.switchyard.Message)mesg, contentType, (RPCActivityType)sent, securityContext, exch);
            }
            if (consumer.getConsumerMetadata().isBinding()) {
                this.getActivityCollector().endScope();
            } else {
                ResponseReceived recvd = new ResponseReceived();
                recvd.setServiceType(serviceType.toString());
                recvd.setInterface(intf);
                recvd.setOperation(opName);
                recvd.setMessageId(messageId);
                recvd.setReplyToId(relatesTo);
                this.record((org.switchyard.Message)mesg, contentType, (RPCActivityType)recvd, securityContext, exch);
            }
        }
    }

    protected String getInterface(ServiceReference consumer, Service provider) {
        String ret = null;
        ServiceInterface intf = null;
        if (consumer.getConsumerMetadata().isBinding()) {
            intf = consumer.getInterface();
        } else if (provider != null) {
            intf = provider.getInterface();
        }
        if (intf != null) {
            if ("java".equals(intf.getType())) {
                ret = ((JavaService)intf).getJavaInterface().getName();
            } else if ("wsdl".equals(intf.getType())) {
                ret = ((WSDLService)intf).getPortType().toString();
            }
        }
        return ret;
    }

    protected void record(org.switchyard.Message msg, String contentType, RPCActivityType at, SecurityContext sc, Exchange exch) {
        if (at != null) {
            at.setMessageType(contentType);
            Object content = msg.getContent();
            at.setContent(this.getActivityCollector().processInformation(null, contentType, content, null, (ActivityType)at));
            if (sc != null) {
                for (Credential cred : sc.getCredentials()) {
                    if (cred instanceof NameCredential) {
                        at.setPrincipal(((NameCredential)cred).getName());
                        break;
                    }
                    if (!(cred instanceof PrincipalCredential)) continue;
                    at.setPrincipal(((PrincipalCredential)cred).getPrincipal().getName());
                    break;
                }
            }
            this.recordActivity(exch, (ActivityType)at);
        }
    }
}

